/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ProgressSuspender
implements AutoCloseable {
    private static final Key<ProgressSuspender> PROGRESS_SUSPENDER = Key.create((String)"PROGRESS_SUSPENDER");
    public static final Topic<SuspenderListener> TOPIC = Topic.create((String)"ProgressSuspender", SuspenderListener.class);
    private final Object myLock = new Object();
    private static final Application ourApp = ApplicationManager.getApplication();
    @NotNull
    private final String mySuspendedText;
    @Nullable
    private String myTempReason;
    private final SuspenderListener myPublisher;
    private volatile boolean mySuspended;
    private final CoreProgressManager.CheckCanceledHook myHook = this::freezeIfNeeded;
    private final Set<ProgressIndicator> myProgresses = ContainerUtil.newConcurrentSet();
    private final Map<ProgressIndicator, Integer> myProgressesInNonSuspendableSections = new ConcurrentHashMap<ProgressIndicator, Integer>();
    private boolean myClosed;

    private ProgressSuspender(@NotNull ProgressIndicatorEx progress2, @NotNull String suspendedText) {
        this.mySuspendedText = suspendedText;
        assert (progress2.isRunning());
        assert (ProgressIndicatorProvider.getGlobalProgressIndicator() == progress2);
        this.myPublisher = (SuspenderListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        this.attachToProgress(progress2);
        new ProgressIndicatorListenerAdapter(){

            @Override
            public void cancelled() {
                ProgressSuspender.this.resumeProcess();
            }
        }.installToProgress(progress2);
        this.myPublisher.suspendableProgressAppeared(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Iterator<ProgressIndicator> iterator2 = this.myLock;
        synchronized (iterator2) {
            this.myClosed = true;
            this.mySuspended = false;
            ((ProgressManagerImpl)ProgressManager.getInstance()).removeCheckCanceledHook(this.myHook);
        }
        for (ProgressIndicator progress2 : this.myProgresses) {
            ((UserDataHolder)progress2).putUserData(PROGRESS_SUSPENDER, null);
        }
    }

    public static ProgressSuspender markSuspendable(@NotNull ProgressIndicator indicator, @NotNull String suspendedText) {
        return new ProgressSuspender((ProgressIndicatorEx)indicator, suspendedText);
    }

    public void executeNonSuspendableSection(@NotNull ProgressIndicator indicator, @NotNull Runnable runnable2) {
        this.myProgressesInNonSuspendableSections.compute(indicator, (__, number) -> (number == null ? 0 : number) + 1);
        try {
            runnable2.run();
        }
        finally {
            this.myProgressesInNonSuspendableSections.compute(indicator, (__, number) -> number == null || number <= 1 ? null : Integer.valueOf(number - 1));
        }
    }

    @Nullable
    public static ProgressSuspender getSuspender(@NotNull ProgressIndicator indicator) {
        return indicator instanceof UserDataHolder ? (ProgressSuspender)((UserDataHolder)indicator).getUserData(PROGRESS_SUSPENDER) : null;
    }

    public void attachToProgress(@NotNull ProgressIndicatorEx progress2) {
        this.myProgresses.add(progress2);
        ((UserDataHolder)progress2).putUserData(PROGRESS_SUSPENDER, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getSuspendedText() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myTempReason != null ? this.myTempReason : this.mySuspendedText;
        }
    }

    public boolean isSuspended() {
        return this.mySuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendProcess(@Nullable String reason) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySuspended || this.myClosed) {
                return;
            }
            this.mySuspended = true;
            this.myTempReason = reason;
            ((ProgressManagerImpl)ProgressManager.getInstance()).addCheckCanceledHook(this.myHook);
        }
        this.myPublisher.suspendedStatusChanged(this);
        ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeProcess() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.mySuspended) {
                return;
            }
            this.mySuspended = false;
            this.myTempReason = null;
            ((ProgressManagerImpl)ProgressManager.getInstance()).removeCheckCanceledHook(this.myHook);
            this.myLock.notifyAll();
        }
        this.myPublisher.suspendedStatusChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean freezeIfNeeded(ProgressIndicator current2) {
        if (current2 == null) {
            current2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        }
        if (current2 == null || !this.myProgresses.contains(current2)) {
            return false;
        }
        if (ProgressSuspender.isCurrentThreadHoldingKnownLocks()) {
            return false;
        }
        if (this.myProgressesInNonSuspendableSections.containsKey(current2)) {
            return false;
        }
        Object object = this.myLock;
        synchronized (object) {
            while (this.mySuspended) {
                try {
                    this.myLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    private static boolean isCurrentThreadHoldingKnownLocks() {
        if (ourApp.isReadAccessAllowed()) {
            return true;
        }
        ThreadInfo[] infos = ManagementFactory.getThreadMXBean().getThreadInfo(new long[]{Thread.currentThread().getId()}, true, false);
        return infos.length > 0 && infos[0].getLockedMonitors().length > 0;
    }

    public static interface SuspenderListener {
        default public void suspendableProgressAppeared(@NotNull ProgressSuspender suspender) {
        }

        default public void suspendedStatusChanged(@NotNull ProgressSuspender suspender) {
        }
    }
}

