/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDynaReference<T extends PsiElement>
extends PsiReferenceBase<T>
implements FileReferenceOwner,
PsiPolyVariantReference,
LocalQuickFixProvider,
EmptyResolveMessageProvider {
    private final List<PsiReference> myReferences = new ArrayList<PsiReference>();
    private int myChosenOne = -1;
    private ResolveResult[] myCachedResult;

    public PsiDynaReference(T psiElement) {
        super(psiElement, true);
    }

    public void addReferences(Collection<? extends PsiReference> references) {
        this.myReferences.addAll(references);
        for (PsiReference psiReference : references) {
            if (psiReference.isSoft()) continue;
            this.mySoft = false;
        }
    }

    public List<PsiReference> getReferences() {
        return this.myReferences;
    }

    public void addReference(PsiReference reference2) {
        this.myReferences.add(reference2);
        if (!reference2.isSoft()) {
            this.mySoft = false;
        }
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiReference resolved = null;
        PsiReference reference2 = this.myReferences.get(0);
        if (reference2.resolve() != null) {
            resolved = reference2;
        }
        TextRange range2 = reference2.getRangeInElement();
        int start2 = range2.getStartOffset();
        int end = range2.getEndOffset();
        for (int i2 = 1; i2 < this.myReferences.size(); ++i2) {
            reference2 = this.myReferences.get(i2);
            TextRange textRange = PsiMultiReference.getReferenceRange(reference2, this.myElement);
            start2 = Math.min(start2, textRange.getStartOffset());
            if (resolved != null) continue;
            end = Math.max(end, textRange.getEndOffset());
        }
        return new TextRange(start2, end);
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        PsiReference reference2 = this.chooseReference();
        return reference2 == null ? this.myReferences.get(0).getCanonicalText() : reference2.getCanonicalText();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiReference reference2 = this.chooseReference();
        if (reference2 != null) {
            return reference2.handleElementRename(newElementName);
        }
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        for (PsiReference reference2 : this.myReferences) {
            if (!(reference2 instanceof FileReference)) continue;
            return reference2.bindToElement(element2);
        }
        return this.myElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        for (PsiReference reference2 : this.myReferences) {
            if (!reference2.isReferenceTo(element2)) continue;
            return true;
        }
        return false;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (this.myCachedResult == null) {
            this.myCachedResult = this.innerResolve(incompleteCode);
        }
        return this.myCachedResult;
    }

    protected ResolveResult[] innerResolve(boolean incompleteCode) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (PsiReference reference2 : this.myReferences) {
            if (reference2 instanceof PsiPolyVariantReference) {
                for (ResolveResult rr : ((PsiPolyVariantReference)reference2).multiResolve(incompleteCode)) {
                    if (!rr.isValidResult()) continue;
                    result2.add(rr);
                }
                continue;
            }
            PsiElement resolved = reference2.resolve();
            if (resolved == null) continue;
            result2.add(new PsiElementResolveResult(resolved));
        }
        return result2.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @Nullable
    private PsiReference chooseReference() {
        if (this.myChosenOne != -1) {
            return this.myReferences.get(this.myChosenOne);
        }
        boolean flag = false;
        for (int i2 = 0; i2 < this.myReferences.size(); ++i2) {
            PsiReference reference2 = this.myReferences.get(i2);
            if (reference2.isSoft() && flag) continue;
            if (!reference2.isSoft() && !flag) {
                this.myChosenOne = i2;
                flag = true;
                continue;
            }
            if (reference2.resolve() == null) continue;
            this.myChosenOne = i2;
        }
        return this.myChosenOne >= 0 ? this.myReferences.get(this.myChosenOne) : null;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        PsiReference reference2 = this.chooseReference();
        return reference2 instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)reference2).getUnresolvedMessagePattern() : AnalysisBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
    }

    public LocalQuickFix[] getQuickFixes() {
        ArrayList list2 = new ArrayList();
        for (PsiReference ref : this.myReferences) {
            if (!(ref instanceof LocalQuickFixProvider)) continue;
            ContainerUtil.addAll(list2, (Object[])((LocalQuickFixProvider)ref).getQuickFixes());
        }
        return list2.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public String toString() {
        return "PsiDynaReference containing " + this.myReferences.toString();
    }

    @Override
    public PsiFileReference getLastFileReference() {
        for (PsiReference reference2 : this.myReferences) {
            if (!(reference2 instanceof FileReferenceOwner)) continue;
            return ((FileReferenceOwner)reference2).getLastFileReference();
        }
        return null;
    }
}

