/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.options.ex.Weighted;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableWrapper
implements SearchableConfigurable,
Weighted {
    static final Logger LOG = Logger.getInstance(ConfigurableWrapper.class);
    private final ConfigurableEP<?> myEp;
    int myWeight;
    @Nullable
    private UnnamedConfigurable myConfigurable;

    @Nullable
    public static <T extends UnnamedConfigurable> T wrapConfigurable(@NotNull ConfigurableEP<T> ep2) {
        return ConfigurableWrapper.wrapConfigurable(ep2, false);
    }

    @Nullable
    public static <T extends UnnamedConfigurable> T wrapConfigurable(@NotNull ConfigurableEP<T> ep2, boolean settings) {
        if (!ep2.canCreateConfigurable()) {
            return null;
        }
        if (settings || ep2.displayName != null || ep2.key != null || ep2.parentId != null || ep2.groupId != null) {
            return (T)(!ep2.dynamic && ep2.children == null && ep2.childrenEPName == null ? new ConfigurableWrapper(ep2) : new CompositeWrapper((ConfigurableEP)ep2, new Configurable[0]));
        }
        return ConfigurableWrapper.createConfigurable(ep2, LOG.isDebugEnabled());
    }

    @Nullable
    private static <T extends UnnamedConfigurable> T createConfigurable(@NotNull ConfigurableEP<T> ep2, boolean log) {
        long time = System.currentTimeMillis();
        UnnamedConfigurable configurable2 = ep2.createConfigurable();
        if (configurable2 instanceof Configurable) {
            ConfigurableCardPanel.warn((Configurable)configurable2, "init", time);
            if (log) {
                LOG.debug("cannot create configurable wrapper for " + configurable2.getClass());
            }
        }
        return (T)configurable2;
    }

    public static <T extends UnnamedConfigurable> List<T> createConfigurables(@NotNull ExtensionPointName<? extends ConfigurableEP<T>> name) {
        List collection = name.getExtensionList();
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result2 = new ArrayList(collection.size());
        for (ConfigurableEP item : collection) {
            T o = ConfigurableWrapper.wrapConfigurable(item, false);
            if (o == null) continue;
            result2.add(o);
        }
        return result2.isEmpty() ? Collections.emptyList() : result2;
    }

    public static boolean hasOwnContent(UnnamedConfigurable configurable2) {
        SearchableConfigurable.Parent parent = ConfigurableWrapper.cast(SearchableConfigurable.Parent.class, configurable2);
        return parent != null && parent.hasOwnContent();
    }

    public static boolean isNonDefaultProject(Configurable configurable2) {
        return configurable2 instanceof NonDefaultProjectConfigurable || configurable2 instanceof ConfigurableWrapper && ((ConfigurableWrapper)configurable2).myEp.nonDefaultProject;
    }

    @Nullable
    public static <T> T cast(@NotNull Class<T> type, UnnamedConfigurable configurable2) {
        if (configurable2 instanceof ConfigurableWrapper) {
            Class configurableType;
            ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable2;
            if (wrapper2.myConfigurable == null && (configurableType = wrapper2.getExtensionPoint().getConfigurableType()) != null && !type.isAssignableFrom(configurableType)) {
                return null;
            }
            configurable2 = wrapper2.getConfigurable();
        }
        return type.isInstance(configurable2) ? (T)type.cast(configurable2) : null;
    }

    private ConfigurableWrapper(@NotNull ConfigurableEP<?> ep2) {
        this.myEp = ep2;
        this.myWeight = ep2.groupWeight;
    }

    @Nullable
    public UnnamedConfigurable getRawConfigurable() {
        return this.myConfigurable;
    }

    public UnnamedConfigurable getConfigurable() {
        if (this.myConfigurable == null) {
            this.myConfigurable = ConfigurableWrapper.createConfigurable(this.myEp, false);
            if (this.myConfigurable == null) {
                LOG.error("Can't instantiate configurable for " + this.myEp);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("created configurable for " + this.myConfigurable.getClass());
            }
        }
        return this.myConfigurable;
    }

    @Override
    public int getWeight() {
        return this.myWeight;
    }

    @Nls
    public String getDisplayName() {
        if (this.myEp.displayName == null && this.myEp.key == null) {
            boolean loaded = this.myConfigurable != null;
            Configurable configurable2 = ConfigurableWrapper.cast(Configurable.class, (UnnamedConfigurable)this);
            if (configurable2 != null) {
                String name = configurable2.getDisplayName();
                if (!loaded && LOG.isDebugEnabled()) {
                    LOG.debug("XML does not provide displayName for " + configurable2.getClass());
                }
                return name;
            }
        }
        return this.myEp.getDisplayName();
    }

    public String getProviderClass() {
        return this.myEp.providerClass;
    }

    @Nullable
    public Project getProject() {
        return this.myEp.getProject();
    }

    @Nullable
    public String getHelpTopic() {
        UnnamedConfigurable configurable2 = this.getConfigurable();
        return configurable2 instanceof Configurable ? ((Configurable)configurable2).getHelpTopic() : null;
    }

    @Nullable
    public JComponent createComponent() {
        UnnamedConfigurable configurable2 = this.getConfigurable();
        return configurable2 == null ? null : configurable2.createComponent();
    }

    public boolean isModified() {
        return this.getConfigurable().isModified();
    }

    public void apply() throws ConfigurationException {
        this.getConfigurable().apply();
    }

    public void reset() {
        this.getConfigurable().reset();
    }

    public void disposeUIResources() {
        UnnamedConfigurable configurable2 = this.myConfigurable;
        if (configurable2 != null) {
            configurable2.disposeUIResources();
            this.myConfigurable = null;
        }
    }

    public void cancel() {
        UnnamedConfigurable configurable2 = this.myConfigurable;
        if (configurable2 != null) {
            configurable2.cancel();
        }
    }

    @NotNull
    public String getId() {
        if (this.myEp.id != null) {
            return this.myEp.id;
        }
        boolean loaded = this.myConfigurable != null;
        SearchableConfigurable configurable2 = ConfigurableWrapper.cast(SearchableConfigurable.class, (UnnamedConfigurable)this);
        if (configurable2 != null) {
            String id2 = configurable2.getId();
            if (!loaded) {
                LOG.debug("XML does not provide id for " + configurable2.getClass());
            }
            return id2;
        }
        return this.myEp.providerClass != null ? this.myEp.providerClass : (this.myEp.instanceClass != null ? this.myEp.instanceClass : this.myEp.implementationClass);
    }

    @NotNull
    public ConfigurableEP<?> getExtensionPoint() {
        return this.myEp;
    }

    public String getParentId() {
        return this.myEp.parentId;
    }

    public ConfigurableWrapper addChild(Configurable configurable2) {
        return new CompositeWrapper((ConfigurableEP)this.myEp, new Configurable[]{configurable2});
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        UnnamedConfigurable configurable2 = this.getConfigurable();
        return configurable2 instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable2).enableSearch(option2) : null;
    }

    @NotNull
    public Class<?> getOriginalClass() {
        UnnamedConfigurable configurable2 = this.getConfigurable();
        return configurable2 instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable2).getOriginalClass() : (configurable2 != null ? configurable2.getClass() : this.getClass());
    }

    private static class CompositeWrapper
    extends ConfigurableWrapper
    implements Configurable.Composite {
        private Configurable[] myKids;
        private Comparator<Configurable> myComparator;
        private boolean isInitialized;

        private CompositeWrapper(@NotNull ConfigurableEP ep2, Configurable ... kids) {
            super(ep2);
            this.myKids = kids;
        }

        public Configurable @NotNull [] getConfigurables() {
            Object composite;
            if (this.isInitialized) {
                return this.myKids;
            }
            long time = System.currentTimeMillis();
            ArrayList<Configurable> list2 = new ArrayList<Configurable>();
            if (((ConfigurableWrapper)this).myEp.dynamic && (composite = CompositeWrapper.cast(Configurable.Composite.class, (UnnamedConfigurable)this)) != null) {
                Collections.addAll(list2, composite.getConfigurables());
            }
            if (((ConfigurableWrapper)this).myEp.children != null) {
                for (ConfigurableEP ep2 : ((ConfigurableWrapper)this).myEp.getChildren()) {
                    if (!ep2.isAvailable()) continue;
                    list2.add((Configurable)CompositeWrapper.wrapConfigurable(ep2));
                }
            }
            if (((ConfigurableWrapper)this).myEp.childrenEPName != null) {
                List extensions2;
                Project project = ((ConfigurableWrapper)this).myEp.getProject();
                ExtensionsArea area = project == null ? ApplicationManager.getApplication().getExtensionArea() : project.getExtensionArea();
                ExtensionPoint point = area.getExtensionPointIfRegistered(((ConfigurableWrapper)this).myEp.childrenEPName);
                if (point == null) {
                    LOG.warn("Cannot find extension point " + ((ConfigurableWrapper)this).myEp.childrenEPName + " in " + area);
                    List extensions3 = Collections.emptyList();
                } else {
                    extensions2 = point.getExtensionList();
                }
                if (!extensions2.isEmpty()) {
                    Configurable.Composite composite2;
                    if (extensions2.get(0) instanceof ConfigurableEP) {
                        for (Object object : extensions2) {
                            list2.add((Configurable)CompositeWrapper.wrapConfigurable((ConfigurableEP)object));
                        }
                    } else if (!((ConfigurableWrapper)this).myEp.dynamic && (composite2 = CompositeWrapper.cast(Configurable.Composite.class, (UnnamedConfigurable)this)) != null) {
                        Collections.addAll(list2, composite2.getConfigurables());
                    }
                }
            }
            Collections.addAll(list2, this.myKids);
            for (Configurable configurable2 : list2) {
                if (!(configurable2 instanceof Weighted) || ((Weighted)configurable2).getWeight() == 0) continue;
                this.myComparator = COMPARATOR;
                list2.sort(this.myComparator);
                break;
            }
            this.myKids = list2.toArray(new Configurable[0]);
            this.isInitialized = true;
            ConfigurableCardPanel.warn((Configurable)this, "children", time);
            return this.myKids;
        }

        @Override
        public ConfigurableWrapper addChild(Configurable configurable2) {
            if (this.myComparator != null) {
                int index = Arrays.binarySearch(this.myKids, configurable2, this.myComparator);
                LOG.assertTrue(index < 0, (Object)"similar configurable is already exist");
                this.myKids = (Configurable[])ArrayUtil.insert((Object[])this.myKids, (int)(-1 - index), (Object)configurable2);
            } else {
                this.myKids = (Configurable[])ArrayUtil.append((Object[])this.myKids, (Object)configurable2);
            }
            return this;
        }
    }
}

