/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModulesScope
extends GlobalSearchScope {
    private final ProjectFileIndex myProjectFileIndex;
    private final Set<? extends Module> myModules;

    public ModulesScope(@NotNull Set<? extends Module> modules2, @NotNull Project project) {
        super(project);
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myModules = modules2;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        Module moduleOfFile = this.myProjectFileIndex.getModuleForFile(file2);
        return moduleOfFile != null && this.myModules.contains(moduleOfFile);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return this.myModules.contains(aModule);
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    public String toString() {
        return "Modules:" + Arrays.toString(this.myModules.toArray(Module.EMPTY_ARRAY));
    }
}

