/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.impl.RemoveInvalidElementsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class ProjectLoadingErrorsNotifierImpl
extends ProjectLoadingErrorsNotifier {
    private final MultiMap<ConfigurationErrorType, ConfigurationErrorDescription> myErrors = new MultiMap();
    private final Object myLock = new Object();
    private final Project myProject;

    public ProjectLoadingErrorsNotifierImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void registerError(@NotNull ConfigurationErrorDescription errorDescription) {
        this.registerErrors(Collections.singletonList(errorDescription));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerErrors(@NotNull Collection<? extends ConfigurationErrorDescription> errorDescriptions) {
        boolean first;
        if (this.myProject.isDisposed() || this.myProject.isDefault() || errorDescriptions.isEmpty()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            first = this.myErrors.isEmpty();
            for (ConfigurationErrorDescription configurationErrorDescription : errorDescriptions) {
                this.myErrors.putValue((Object)configurationErrorDescription.getErrorType(), (Object)configurationErrorDescription);
            }
        }
        if (this.myProject.isInitialized()) {
            this.fireNotifications();
        } else if (first) {
            StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> this.fireNotifications());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotifications() {
        Map descriptionMap;
        Iterator iterator2 = this.myLock;
        synchronized (iterator2) {
            if (this.myErrors.isEmpty()) {
                return;
            }
            descriptionMap = this.myErrors.toHashMap();
            this.myErrors.clear();
        }
        for (Map.Entry entry : descriptionMap.entrySet()) {
            final Collection descriptions = (Collection)entry.getValue();
            if (descriptions.isEmpty()) continue;
            final ConfigurationErrorType type = (ConfigurationErrorType)entry.getKey();
            final String invalidElements = ProjectLoadingErrorsNotifierImpl.getInvalidElementsString(type, descriptions);
            String errorText = ProjectBundle.message((String)"error.message.configuration.cannot.load", (Object[])new Object[]{invalidElements});
            new Notification(NotificationGroup.createIdWithTitle((String)"Project Loading Error", (String)ProjectBundle.message((String)"notification.group.project.loading.error", (Object[])new Object[0])), ProjectBundle.message((String)"notification.title.error.loading.project", (Object[])new Object[0]), errorText, NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    List validDescriptions = ContainerUtil.findAll((Collection)descriptions, ConfigurationErrorDescription::isValid);
                    if (RemoveInvalidElementsDialog.showDialog(ProjectLoadingErrorsNotifierImpl.this.myProject, CommonBundle.getErrorTitle(), type, invalidElements, validDescriptions)) {
                        notification.expire();
                    }
                }
            }).notify(this.myProject);
        }
    }

    private static String getInvalidElementsString(ConfigurationErrorType type, Collection<ConfigurationErrorDescription> descriptions) {
        if (descriptions.size() == 1) {
            return type.getElementKind() + " " + ((ConfigurationErrorDescription)ContainerUtil.getFirstItem(descriptions)).getElementName();
        }
        return descriptions.size() + " " + StringUtil.pluralize((String)type.getElementKind());
    }
}

