/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.ModuleStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.NonPersistentModuleStore;
import com.intellij.openapi.module.impl.scopes.ModuleScopeProviderImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleImpl
extends ComponentManagerImpl
implements ModuleEx {
    private static final Logger LOG = Logger.getInstance(ModuleImpl.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final VirtualFilePointer myImlFilePointer;
    private volatile boolean isModuleAdded;
    private String myName;
    private final ModuleScopeProvider myModuleScopeProvider;

    @ApiStatus.Internal
    public ModuleImpl(@NotNull String name, @NotNull Project project, @Nullable String filePath) {
        super((ComponentManagerImpl)project);
        this.registerServiceInstance(Module.class, this, (PluginDescriptor)ComponentManagerImpl.getFakeCorePluginDescriptor());
        this.myProject = project;
        this.myModuleScopeProvider = new ModuleScopeProviderImpl(this);
        this.myName = name;
        this.myImlFilePointer = filePath == null ? null : VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl((String)filePath), (Disposable)this, new VirtualFilePointerListener(){

            public void validityChanged(@NotNull @NotNull VirtualFilePointer @NotNull [] pointers2) {
                VirtualFile virtualFile = ModuleImpl.this.myImlFilePointer.getFile();
                if (virtualFile != null) {
                    ((ModuleStore)ModuleImpl.this.getStore()).setPath(virtualFile.toNioPath(), virtualFile, false);
                    ModuleManager.getInstance((Project)ModuleImpl.this.myProject).incModificationCount();
                }
            }
        });
    }

    @Override
    public void init(@Nullable Runnable beforeComponentCreation) {
        this.registerComponents(PluginManagerCore.getLoadedPlugins());
        if (!this.isPersistent()) {
            this.registerService(IComponentStore.class, NonPersistentModuleStore.class, (PluginDescriptor)Objects.requireNonNull(PluginManagerCore.getPlugin(PluginManagerCore.CORE_ID), "Could not find plugin by id: " + PluginManagerCore.CORE_ID), true);
        }
        if (beforeComponentCreation != null) {
            beforeComponentCreation.run();
        }
        this.createComponents(null);
    }

    private boolean isPersistent() {
        return this.myImlFilePointer != null;
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
    }

    public final boolean isDisposed() {
        return super.isDisposed() || ((ProjectEx)this.myProject).isLight() && this.myProject.isDisposed();
    }

    protected boolean isComponentSuitable(@NotNull ComponentConfig componentConfig) {
        if (!super.isComponentSuitable(componentConfig)) {
            return false;
        }
        Map options2 = componentConfig.options;
        if (options2 == null || options2.isEmpty()) {
            return true;
        }
        for (String optionName : options2.keySet()) {
            if ("workspace".equals(optionName) || "overrides".equals(optionName)) continue;
            String message = "Don't specify " + optionName + " in the component registration, transform component to service and implement your logic in your getInstance() method";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message);
                continue;
            }
            LOG.warn(message);
        }
        return true;
    }

    @Nullable
    public VirtualFile getModuleFile() {
        if (this.myImlFilePointer == null) {
            return null;
        }
        return this.myImlFilePointer.getFile();
    }

    @Override
    public void rename(@NotNull String newName, boolean notifyStorage) {
        this.myName = newName;
        if (notifyStorage) {
            this.getStore().getStorageManager().rename("$MODULE_FILE$", newName + ".iml");
        }
    }

    @NotNull
    private IComponentStore getStore() {
        return (IComponentStore)Objects.requireNonNull(this.getService(IComponentStore.class));
    }

    @NotNull
    public String getModuleFilePath() {
        if (!this.isPersistent()) {
            return "";
        }
        return this.getStore().getStorageManager().expandMacros("$MODULE_FILE$");
    }

    public synchronized void dispose() {
        this.isModuleAdded = false;
        super.dispose();
    }

    @NotNull
    protected ContainerDescriptor getContainerDescriptor(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        return pluginDescriptor.getModule();
    }

    @Override
    public void projectOpened() {
        for (ModuleComponent component2 : this.getModuleComponents()) {
            try {
                component2.projectOpened();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void projectClosed() {
        List<ModuleComponent> components = this.getModuleComponents();
        for (int i2 = components.size() - 1; i2 >= 0; --i2) {
            try {
                components.get(i2).projectClosed();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public boolean isLoaded() {
        return this.isModuleAdded;
    }

    @Override
    public void moduleAdded() {
        this.isModuleAdded = true;
        for (ModuleComponent component2 : this.getModuleComponents()) {
            component2.moduleAdded();
        }
    }

    @NotNull
    private List<ModuleComponent> getModuleComponents() {
        return this.getComponentInstancesOfType(ModuleComponent.class);
    }

    public void setOption(@NotNull String key, @Nullable String value2) {
        DeprecatedModuleOptionManager manager = this.getOptionManager();
        if (value2 == null) {
            if (((DeprecatedModuleOptionManager)manager).state.options.remove(key) != null) {
                manager.incModificationCount();
            }
        } else if (!value2.equals(((DeprecatedModuleOptionManager)manager).state.options.put(key, value2))) {
            manager.incModificationCount();
        }
    }

    @NotNull
    private DeprecatedModuleOptionManager getOptionManager() {
        return (DeprecatedModuleOptionManager)((Object)this.getService(DeprecatedModuleOptionManager.class));
    }

    public String getOptionValue(@NotNull String key) {
        return ((DeprecatedModuleOptionManager)this.getOptionManager()).state.options.get(key);
    }

    @NotNull
    public GlobalSearchScope getModuleScope() {
        return this.myModuleScopeProvider.getModuleScope();
    }

    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleScope(includeTests);
    }

    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        return this.myModuleScopeProvider.getModuleWithLibrariesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        return this.myModuleScopeProvider.getModuleWithDependenciesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        return this.myModuleScopeProvider.getModuleContentScope();
    }

    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        return this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        return this.myModuleScopeProvider.getModuleWithDependentsScope();
    }

    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        return this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
    }

    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    public String toString() {
        if (this.myName == null) {
            return "Module (not initialized)";
        }
        return "Module: '" + this.getName() + "'";
    }

    @Override
    public long getOptionsModificationCount() {
        return this.getOptionManager().getModificationCount();
    }

    @com.intellij.openapi.components.State(name="DeprecatedModuleOptionManager", useLoadedStateAsExisting=false)
    @ApiStatus.Internal
    public static class DeprecatedModuleOptionManager
    extends SimpleModificationTracker
    implements PersistentStateComponent<State>,
    ProjectModelElement {
        private final Module module;
        private State state = new State();

        DeprecatedModuleOptionManager(@NotNull Module module) {
            this.module = module;
        }

        @Nullable
        public ProjectModelExternalSource getExternalSource() {
            if (this.state.options.size() > 1 || this.state.options.size() == 1 && !this.state.options.containsKey("type")) {
                return null;
            }
            return ExternalProjectSystemRegistry.getInstance().getExternalSource(this.module);
        }

        @Nullable
        public State getState() {
            return this.state;
        }

        public void loadState(@NotNull State state) {
            this.state = state;
        }

        static final class State {
            @Property(surroundWithTag=false)
            @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false, surroundWithTag=false, entryTagName="option")
            public final Map<String, String> options = new THashMap();

            State() {
            }
        }
    }
}

