/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.project.ProjectBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class WebModuleTypeBase<T extends ModuleBuilder>
extends ModuleType<T>
implements ModuleTypeWithWebFeatures {
    @NonNls
    public static final String WEB_MODULE = "WEB_MODULE";

    public WebModuleTypeBase() {
        super(WEB_MODULE);
    }

    @NotNull
    public static WebModuleTypeBase<?> getInstance() {
        return (WebModuleTypeBase)ModuleTypeManager.getInstance().findByID(WEB_MODULE);
    }

    @NotNull
    public String getName() {
        return ProjectBundle.message((String)"module.web.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getDescription() {
        return ProjectBundle.message((String)"module.web.description", (Object[])new Object[0]);
    }

    @NotNull
    public Icon getNodeIcon(boolean isOpened) {
        return AllIcons.Nodes.Module;
    }

    @Deprecated
    public static boolean isWebModule(@NotNull Module module) {
        return ModuleTypeWithWebFeatures.isAvailable(module);
    }

    @Override
    public boolean hasWebFeatures(@NotNull Module module) {
        return WEB_MODULE.equals(ModuleType.get((Module)module).getId());
    }
}

