/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.diagnostic.VMOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.NationalKeyboardSupport;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.SystemShortcuts;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.keymap.impl.ui.KeymapSelector;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.ShortcutFilteringPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.util.Alarm;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapPanel
extends JPanel
implements SearchableConfigurable,
Configurable.NoScroll,
KeymapListener,
Disposable {
    private JCheckBox nationalKeyboardsSupport;
    private final KeymapSelector myKeymapSelector = new KeymapSelector(this::currentKeymapChanged);
    private final KeymapSchemeManager myManager = this.myKeymapSelector.getManager();
    private final ActionsTree myActionsTree = new ActionsTree();
    private FilterComponent myFilterComponent;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private final ShortcutFilteringPanel myFilteringPanel = new ShortcutFilteringPanel();
    private boolean myQuickListsModified = false;
    private QuickList[] myQuickLists = QuickListsManager.getInstance().getAllQuickLists();
    private ShowFNKeysSettingWrapper myShowFN;
    private boolean myShowOnlyConflicts;
    private JPanel mySystemShortcutConflictsPanel;
    private ToggleActionButton myShowOnlyConflictsButton;

    public KeymapPanel() {
        this(false);
    }

    public KeymapPanel(boolean showOnlyConflicts) {
        this.myShowOnlyConflicts = showOnlyConflicts;
        this.setLayout(new BorderLayout());
        JPanel keymapPanel = new JPanel(new BorderLayout());
        keymapPanel.add(this.myManager.getSchemesPanel(), "North");
        keymapPanel.add((Component)this.createKeymapSettingsPanel(), "Center");
        IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (ideFrame != null && NationalKeyboardSupport.isSupportedKeyboardLayout((Component)ideFrame.getComponent())) {
            this.nationalKeyboardsSupport = new JCheckBox(new AbstractAction(KeyMapBundle.message((String)NationalKeyboardSupport.getKeymapBundleKey(), (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NationalKeyboardSupport.getInstance().setEnabled(KeymapPanel.this.nationalKeyboardsSupport.isSelected());
                    VMOptions.writeOption(NationalKeyboardSupport.getVMOption(), "=", Boolean.toString(NationalKeyboardSupport.getInstance().getEnabled()));
                    ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().restart(), ModalityState.NON_MODAL);
                }
            });
            this.nationalKeyboardsSupport.setSelected(NationalKeyboardSupport.getInstance().getEnabled());
            this.nationalKeyboardsSupport.setBorder((Border)JBUI.Borders.empty());
            keymapPanel.add((Component)this.nationalKeyboardsSupport, "South");
        }
        this.add((Component)keymapPanel, "Center");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null && KeymapPanel.this.myQuickListsModified) {
                    KeymapPanel.this.currentKeymapChanged();
                    KeymapPanel.this.myQuickListsModified = false;
                }
            }
        });
        this.myFilteringPanel.addPropertyChangeListener("shortcut", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                KeymapPanel.this.filterTreeByShortcut(KeymapPanel.this.myFilteringPanel.getShortcut());
            }
        });
        this.mySystemShortcutConflictsPanel = new JPanel(new FlowLayout(0, 0, 5));
        this.add((Component)this.mySystemShortcutConflictsPanel, "South");
        KeymapExtension.EXTENSION_POINT_NAME.addChangeListener(this::currentKeymapChanged, (Disposable)this);
    }

    private void fillConflictsPanel(@NotNull Keymap keymap2) {
        this.mySystemShortcutConflictsPanel.removeAll();
        SystemShortcuts systemShortcuts = SystemShortcuts.getInstance();
        @NotNull Collection<SystemShortcuts.ConflictItem> allConflicts = systemShortcuts.getUnmutedKeymapConflicts();
        if (allConflicts.isEmpty()) {
            return;
        }
        String htmlBody = "";
        final HashMap<String, Runnable> href2linkAction = new HashMap<String, Runnable>();
        int count = 0;
        boolean empty = true;
        for (SystemShortcuts.ConflictItem conf : allConflicts) {
            String actText;
            String actId = conf.getActionIds()[0];
            href2linkAction.put(actId, () -> {
                KeyboardShortcut confShortcut = KeymapPanel.findKeyboardShortcut(keymap2, conf.getSysKeyStroke(), actId);
                KeymapPanel.addKeyboardShortcut(actId, ActionShortcutRestrictions.getInstance().getForActionId(actId), keymap2, (Component)this, confShortcut, systemShortcuts, this.myQuickLists);
            });
            AnAction act = ActionManager.getInstance().getAction(actId);
            String string = actText = act == null ? actId : act.getTemplateText();
            if (!empty) {
                htmlBody = htmlBody + ", ";
            }
            htmlBody = htmlBody + "<a href='" + actId + "'>" + actText + "</a>";
            empty = false;
            if (++count <= 2) continue;
            break;
        }
        if (count > 2 && allConflicts.size() > count) {
            @NotNull String text = String.format("%d more", allConflicts.size() - count);
            htmlBody = htmlBody + " and <a href='" + text + "'>" + text + "</a>";
            href2linkAction.put(text, () -> {
                this.myShowOnlyConflicts = true;
                this.myActionsTree.setBaseFilter(systemShortcuts.createKeymapConflictsActionFilter());
                this.myActionsTree.filter(null, this.myQuickLists);
                TreeUtil.expandAll((JTree)this.myActionsTree.getTree());
            });
        }
        htmlBody = htmlBody + " shortcuts conflict with the macOS system shortcuts.<br>Assign custom shortcuts or change the macOS system settings.</p></html>";
        JBLabel jbLabel = new JBLabel(KeymapPanel.createWarningHtmlText(htmlBody)){

            @NotNull
            protected HyperlinkListener createHyperlinkListener() {
                return new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        String href;
                        Runnable act;
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (act = (Runnable)href2linkAction.get(href = e.getDescription())) != null) {
                            act.run();
                        }
                    }
                };
            }
        };
        jbLabel.setCopyable(true);
        jbLabel.setAllowAutoWrapping(true);
        jbLabel.setIconWithAlignment(AllIcons.General.Warning, 2, 1);
        this.mySystemShortcutConflictsPanel.add((Component)jbLabel);
        this.validate();
        this.repaint();
    }

    private static String createWarningHtmlText(@Nullable String htmlBody) {
        if (htmlBody == null) {
            return null;
        }
        String css = "<head><style type=\"text/css\">\na, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkColor()) + ";}\na:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkVisitedColor()) + ";}\na:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkHoverColor()) + ";}\na:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkPressedColor()) + ";}\n</style>\n</head>";
        return String.format("<html>" + css + "<body><div>%s</div></body></html>", htmlBody);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myFilteringPanel != null) {
            SwingUtilities.updateComponentTreeUI(this.myFilteringPanel);
        }
    }

    @Override
    public void quickListRenamed(@NotNull QuickList oldQuickList, @NotNull QuickList newQuickList) {
        this.myManager.visitMutableKeymaps(keymap2 -> {
            String actionId = oldQuickList.getActionId();
            Shortcut[] shortcuts = keymap2.getShortcuts(actionId);
            if (shortcuts.length != 0) {
                String newActionId = newQuickList.getActionId();
                for (Shortcut shortcut : shortcuts) {
                    keymap2.removeShortcut(actionId, shortcut);
                    keymap2.addShortcut(newActionId, shortcut);
                }
            }
        });
        this.myQuickListsModified = true;
    }

    public Runnable enableSearch(String option2) {
        return () -> this.showOption(option2);
    }

    @Override
    public void processCurrentKeymapChanged() {
        this.currentKeymapChanged();
    }

    @Override
    public void processCurrentKeymapChanged(QuickList @NotNull [] ids) {
        this.myQuickLists = ids;
        this.currentKeymapChanged();
    }

    private void currentKeymapChanged() {
        this.currentKeymapChanged(this.myManager.getSelectedKeymap());
    }

    private void currentKeymapChanged(Keymap selectedKeymap) {
        if (selectedKeymap == null) {
            selectedKeymap = new KeymapImpl();
        }
        SystemShortcuts systemShortcuts = SystemShortcuts.getInstance();
        systemShortcuts.updateKeymapConflicts(selectedKeymap);
        this.myShowOnlyConflictsButton.setVisible(!systemShortcuts.getUnmutedKeymapConflicts().isEmpty());
        this.myActionsTree.setBaseFilter(this.myShowOnlyConflicts ? systemShortcuts.createKeymapConflictsActionFilter() : null);
        this.myActionsTree.reset(selectedKeymap, this.myQuickLists);
        this.fillConflictsPanel(selectedKeymap);
    }

    private JPanel createKeymapSettingsPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.createToolbarPanel(), "North");
        panel2.add((Component)this.myActionsTree.getComponent(), "Center");
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                KeymapPanel.this.editSelection(e, true);
                return true;
            }
        }.installOn((Component)this.myActionsTree.getTree());
        this.myActionsTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e, false);
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e, false);
                    e.consume();
                }
            }
        });
        if (TouchBarsManager.isTouchBarAvailable()) {
            this.myShowFN = new ShowFNKeysSettingWrapper();
            if (this.myShowFN.getCheckbox() != null) {
                panel2.add((Component)this.myShowFN.getCheckbox(), "South");
            }
            Disposer.register((Disposable)this, (Disposable)this.myShowFN);
        }
        return panel2;
    }

    private JPanel createToolbarPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("KeymapEdit", (ActionGroup)group, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = KeymapPanel.createTreeExpander(this.myActionsTree);
        group.add(commonActionsManager.createExpandAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(commonActionsManager.createCollapseAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(new AnAction(IdeBundle.message((String)"action.text.edit.shortcut", (Object[])new Object[0]), IdeBundle.message((String)"action.text.edit.shortcut", (Object[])new Object[0]), AllIcons.Actions.Edit){
            {
                this.registerCustomShortcutSet(CommonShortcuts.ENTER, KeymapPanel.this.myActionsTree.getTree());
            }

            public void update(@NotNull AnActionEvent e) {
                String actionId = KeymapPanel.this.myActionsTree.getSelectedActionId();
                e.getPresentation().setEnabled(actionId != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                KeymapPanel.this.editSelection(e.getInputEvent(), false);
            }
        });
        this.myShowOnlyConflictsButton = new ToggleActionButton(KeyMapBundle.messagePointer((String)"action.AnActionButton.text.show.conflicts.with.system.shortcuts", (Object[])new Object[0]), AllIcons.General.ShowWarning){

            public boolean isSelected(AnActionEvent e) {
                return KeymapPanel.this.myShowOnlyConflicts;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                KeymapPanel.this.myShowOnlyConflicts = state;
                KeymapPanel.this.myActionsTree.setBaseFilter(KeymapPanel.this.myShowOnlyConflicts ? SystemShortcuts.getInstance().createKeymapConflictsActionFilter() : null);
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.myQuickLists);
                JTree tree = KeymapPanel.this.myActionsTree.getTree();
                if (KeymapPanel.this.myShowOnlyConflicts) {
                    TreeUtil.expandAll((JTree)tree);
                } else {
                    TreeUtil.collapseAll((JTree)tree, (int)0);
                }
            }
        };
        group.add((AnAction)this.myShowOnlyConflictsButton);
        panel2.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("Keymap", (ActionGroup)group, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent searchToolbar = actionToolbar.getComponent();
        final Alarm alarm2 = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP", 5){

            public void filter() {
                alarm2.cancelAllRequests();
                alarm2.addRequest(() -> {
                    if (!KeymapPanel.this.myFilterComponent.isShowing()) {
                        return;
                    }
                    KeymapPanel.this.myTreeExpansionMonitor.freeze();
                    KeymapPanel.this.myFilteringPanel.setShortcut(null);
                    String filter2 = this.getFilter();
                    KeymapPanel.this.myActionsTree.filter(filter2, KeymapPanel.this.myQuickLists);
                    JTree tree = KeymapPanel.this.myActionsTree.getTree();
                    TreeUtil.expandAll((JTree)tree);
                    if (filter2 == null || filter2.length() == 0) {
                        TreeUtil.collapseAll((JTree)tree, (int)0);
                        KeymapPanel.this.myTreeExpansionMonitor.restore();
                    } else {
                        KeymapPanel.this.myTreeExpansionMonitor.unfreeze();
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        panel2.add((Component)this.myFilterComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), AllIcons.Actions.ShortcutFilter){

            public void actionPerformed(@NotNull AnActionEvent e) {
                KeymapPanel.this.myFilterComponent.reset();
                KeymapPanel.this.currentKeymapChanged();
                KeymapPanel.this.myFilteringPanel.showPopup(searchToolbar, e.getInputEvent().getComponent());
            }
        });
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), AllIcons.Actions.GC){

            public void update(@NotNull AnActionEvent event) {
                boolean enabled = null != KeymapPanel.this.myFilteringPanel.getShortcut();
                Presentation presentation2 = event.getPresentation();
                presentation2.setEnabled(enabled);
                presentation2.setIcon(enabled ? AllIcons.Actions.Cancel : EmptyIcon.ICON_16);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                KeymapPanel.this.myTreeExpansionMonitor.freeze();
                KeymapPanel.this.myFilteringPanel.setShortcut(null);
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.myQuickLists);
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
                KeymapPanel.this.myTreeExpansionMonitor.restore();
            }
        });
        panel2.add((Component)searchToolbar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        return panel2;
    }

    @NotNull
    public static TreeExpander createTreeExpander(@NotNull ActionsTree actionsTree) {
        return new DefaultTreeExpander(actionsTree::getTree);
    }

    private void filterTreeByShortcut(Shortcut shortcut) {
        boolean wasFreezed = this.myTreeExpansionMonitor.isFreeze();
        if (!wasFreezed) {
            this.myTreeExpansionMonitor.freeze();
        }
        this.myActionsTree.filterTree(shortcut, this.myQuickLists);
        JTree tree = this.myActionsTree.getTree();
        TreeUtil.expandAll((JTree)tree);
        if (!wasFreezed) {
            this.myTreeExpansionMonitor.restore();
        }
    }

    public void showOption(String option2) {
        this.currentKeymapChanged();
        this.myFilterComponent.setFilter(option2);
        this.myFilteringPanel.setShortcut(null);
        this.myActionsTree.filter(option2, this.myQuickLists);
    }

    public static void addKeyboardShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, QuickList ... quickLists) {
        KeymapPanel.addKeyboardShortcut(actionId, restrictions, keymapSelected, parent, null, null, quickLists);
    }

    public static void addKeyboardShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, @Nullable KeyboardShortcut selectedShortcut, @Nullable SystemShortcuts systemShortcuts, QuickList ... quickLists) {
        Keymap keymap2;
        Map<KeyboardShortcut, String> kscs;
        if (!restrictions.allowKeyboardShortcut) {
            return;
        }
        KeyboardShortcutDialog dialog2 = new KeyboardShortcutDialog(parent, restrictions.allowKeyboardSecondStroke, systemShortcuts == null ? null : systemShortcuts.createKeystroke2SysShortcutMap());
        KeyboardShortcut keyboardShortcut = dialog2.showAndGet(actionId, keymapSelected, selectedShortcut, quickLists);
        if (keyboardShortcut == null) {
            return;
        }
        SafeKeymapAccessor accessor = new SafeKeymapAccessor(parent, keymapSelected);
        if (dialog2.hasConflicts()) {
            int result2 = KeymapPanel.showConfirmationDialog(parent);
            if (result2 == 0) {
                Keymap keymap3 = accessor.keymap();
                Map conflicts = keymap3.getConflicts(actionId, keyboardShortcut);
                for (String id2 : conflicts.keySet()) {
                    for (KeyboardShortcut s : (List)conflicts.get(id2)) {
                        keymap3.removeShortcut(id2, (Shortcut)s);
                    }
                }
            } else if (result2 != 1) {
                return;
            }
        }
        if (systemShortcuts != null && (kscs = systemShortcuts.calculateConflicts(keymap2 = accessor.keymap(), actionId)) != null && !kscs.isEmpty()) {
            for (KeyboardShortcut ksc : kscs.keySet()) {
                int result3;
                String keyDesc = StringUtil.notNullize((String)KeymapUtil.getKeystrokeText((KeyStroke)ksc.getFirstKeyStroke()));
                if (ksc.getSecondKeyStroke() != null) {
                    keyDesc = keyDesc + ", " + KeymapUtil.getKeystrokeText((KeyStroke)ksc.getSecondKeyStroke());
                }
                if ((result3 = Messages.showYesNoCancelDialog((Component)parent, (String)IdeBundle.message((String)"message.action.shortcut.0.is.already.assigned.to.system.action.1.do.you.want.to.remove.this.shortcut", (Object[])new Object[]{keyDesc, kscs.get(ksc)}), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) != 0) continue;
                keymap2.removeShortcut(actionId, (Shortcut)ksc);
            }
        }
        accessor.add(actionId, (Shortcut)keyboardShortcut);
        if (systemShortcuts != null) {
            systemShortcuts.updateKeymapConflicts(accessor.keymap());
        }
    }

    private static void addMouseShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, QuickList ... quickLists) {
        if (!restrictions.allowMouseShortcut) {
            return;
        }
        MouseShortcutDialog dialog2 = new MouseShortcutDialog(parent, restrictions.allowMouseDoubleClick);
        MouseShortcut mouseShortcut = (MouseShortcut)dialog2.showAndGet(actionId, keymapSelected, quickLists);
        if (mouseShortcut == null) {
            return;
        }
        SafeKeymapAccessor accessor = new SafeKeymapAccessor(parent, keymapSelected);
        if (dialog2.hasConflicts()) {
            int result2 = KeymapPanel.showConfirmationDialog(parent);
            if (result2 == 0) {
                Keymap keymap2 = accessor.keymap();
                for (String id2 : keymap2.getActionIds(mouseShortcut)) {
                    keymap2.removeShortcut(id2, (Shortcut)mouseShortcut);
                }
            } else if (result2 != 1) {
                return;
            }
        }
        accessor.add(actionId, (Shortcut)mouseShortcut);
    }

    private void repaintLists() {
        this.myActionsTree.getComponent().repaint();
    }

    @NotNull
    public String getId() {
        return "preferences.keymap";
    }

    public void reset() {
        if (this.nationalKeyboardsSupport != null) {
            this.nationalKeyboardsSupport.setSelected(NationalKeyboardSupport.getInstance().getEnabled());
        }
        this.myManager.reset();
    }

    public void apply() throws ConfigurationException {
        String error = this.myManager.apply();
        if (error != null) {
            throw new ConfigurationException(error);
        }
        ActionToolbarImpl.updateAllToolbarsImmediately();
        if (this.myShowFN != null) {
            this.myShowFN.applyChanges();
        }
    }

    public boolean isModified() {
        return this.myManager.isModified() || this.myShowFN != null && this.myShowFN.isModified();
    }

    public void selectAction(String actionId) {
        this.myActionsTree.selectAction(actionId);
    }

    @Nls
    public String getDisplayName() {
        return KeyMapBundle.message((String)"keymap.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.keymap";
    }

    public JComponent createComponent() {
        this.myKeymapSelector.attachKeymapListener(this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CHANGE_TOPIC, (Object)this);
        return this;
    }

    public void disposeUIResources() {
        this.myFilteringPanel.hidePopup();
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    public Shortcut @Nullable [] getCurrentShortcuts(@NotNull String actionId) {
        Keymap keymap2 = this.myManager.getSelectedKeymap();
        return keymap2 == null ? null : keymap2.getShortcuts(actionId);
    }

    private void editSelection(InputEvent e, boolean isDoubleClick) {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        Keymap selectedKeymap = this.myManager.getSelectedKeymap();
        if (selectedKeymap == null) {
            return;
        }
        DefaultActionGroup group = this.createEditActionGroup(actionId, selectedKeymap);
        if (e instanceof MouseEvent && ((MouseEvent)e).isPopupTrigger()) {
            ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group).getComponent().show(e.getComponent(), ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
        } else if (!isDoubleClick || !ActionManager.getInstance().isGroup(actionId)) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(IdeBundle.message((String)"popup.title.edit.shortcuts", (Object[])new Object[0]), (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            if (e instanceof MouseEvent) {
                popup2.show(new RelativePoint((MouseEvent)e));
            } else {
                popup2.showInBestPositionFor(dataContext);
            }
        }
    }

    @NotNull
    private DefaultActionGroup createEditActionGroup(final @NotNull String actionId, final Keymap selectedKeymap) {
        DefaultActionGroup group = new DefaultActionGroup();
        final ShortcutRestrictions restrictions = ActionShortcutRestrictions.getInstance().getForActionId(actionId);
        if (restrictions.allowKeyboardShortcut) {
            group.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.add.keyboard.shortcut", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    KeymapPanel.addKeyboardShortcut(actionId, restrictions, selectedKeymap, (Component)KeymapPanel.this, null, SystemShortcuts.getInstance(), KeymapPanel.this.myQuickLists);
                    KeymapPanel.this.currentKeymapChanged();
                }
            });
        }
        if (restrictions.allowMouseShortcut) {
            group.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.add.mouse.shortcut", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    KeymapPanel.addMouseShortcut(actionId, restrictions, selectedKeymap, KeymapPanel.this, KeymapPanel.this.myQuickLists);
                    KeymapPanel.this.currentKeymapChanged();
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations") && restrictions.allowAbbreviation) {
            group.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.add.abbreviation", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    String abbr = Messages.showInputDialog((String)IdeBundle.message((String)"label.enter.new.abbreviation", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.abbreviation", (Object[])new Object[0]), null);
                    if (abbr != null) {
                        AbbreviationManager.getInstance().register(abbr, actionId);
                        KeymapPanel.this.repaintLists();
                    }
                }
            });
        }
        group.addSeparator();
        for (final Shortcut shortcut : selectedKeymap.getShortcuts(actionId)) {
            group.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"action.text.remove.0", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut)})){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Keymap keymap2 = KeymapPanel.this.myManager.getMutableKeymap(selectedKeymap);
                    keymap2.removeShortcut(actionId, shortcut);
                    if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
                        keymap2.removeShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), shortcut);
                    }
                    KeymapPanel.this.currentKeymapChanged();
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations")) {
            for (final String abbreviation : AbbreviationManager.getInstance().getAbbreviations(actionId)) {
                group.addAction((AnAction)new DumbAwareAction(IdeBundle.message((String)"action.text.remove.abbreviation.0", (Object[])new Object[]{abbreviation})){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        AbbreviationManager.getInstance().remove(abbreviation, actionId);
                        KeymapPanel.this.repaintLists();
                    }
                });
            }
        }
        if (this.myManager.canResetActionInKeymap(selectedKeymap, actionId)) {
            group.add((AnAction)new Separator());
            group.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.reset.shortcuts", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    KeymapPanel.this.myManager.resetActionInKeymap(selectedKeymap, actionId);
                    KeymapPanel.this.repaintLists();
                }
            });
        }
        return group;
    }

    private static int showConfirmationDialog(Component parent) {
        return Messages.showYesNoCancelDialog((Component)parent, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
    }

    @Nullable
    private static KeyboardShortcut findKeyboardShortcut(@NotNull Keymap keymap2, @NotNull KeyStroke ks, @NotNull String actionId) {
        Shortcut[] actionShortcuts = keymap2.getShortcuts(actionId);
        if (actionShortcuts == null || actionShortcuts.length == 0) {
            return null;
        }
        for (Shortcut sc : actionShortcuts) {
            KeyboardShortcut ksc;
            if (!(sc instanceof KeyboardShortcut) || !ks.equals((ksc = (KeyboardShortcut)sc).getFirstKeyStroke()) && !ks.equals(ksc.getSecondKeyStroke())) continue;
            return ksc;
        }
        return null;
    }

    private static final class SafeKeymapAccessor {
        private final Component parent;
        private final Keymap selected;
        private KeymapSchemeManager manager;
        private Keymap mutable;

        SafeKeymapAccessor(@NotNull Component parent, @NotNull Keymap selected2) {
            this.parent = parent;
            this.selected = selected2;
        }

        Keymap keymap() {
            if (this.mutable == null) {
                if (this.parent instanceof KeymapPanel) {
                    KeymapPanel panel2 = (KeymapPanel)this.parent;
                    this.mutable = panel2.myManager.getMutableKeymap(this.selected);
                } else {
                    if (this.manager == null) {
                        this.manager = new KeymapSelector(selectedKeymap -> {}).getManager();
                        this.manager.reset();
                    }
                    this.mutable = this.manager.getMutableKeymap(this.selected);
                }
            }
            return this.mutable;
        }

        void add(@NotNull String actionId, @NotNull Shortcut newShortcut) {
            Shortcut[] shortcuts;
            Keymap keymap2 = this.keymap();
            for (Shortcut shortcut : shortcuts = keymap2.getShortcuts(actionId)) {
                if (!shortcut.equals(newShortcut)) continue;
                if (this.manager != null) {
                    this.manager.apply();
                }
                return;
            }
            keymap2.addShortcut(actionId, newShortcut);
            if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
                keymap2.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), newShortcut);
            }
            if (this.manager != null) {
                this.manager.apply();
            }
        }
    }

    private static class ShowFNKeysSettingWrapper
    implements Disposable {
        private boolean myShowFnInitial = false;
        private JCheckBox myCheckbox = null;
        private volatile boolean myDisposed;

        ShowFNKeysSettingWrapper() {
            if (TouchBarsManager.isTouchBarAvailable()) {
                String appId = Utils.getAppId();
                if (appId != null && !appId.isEmpty()) {
                    this.myShowFnInitial = NSDefaults.isShowFnKeysEnabled((String)appId);
                    this.myCheckbox = new JCheckBox(KeyMapBundle.message((String)"keymap.show.f.on.touch.bar", (Object[])new Object[0]), this.myShowFnInitial);
                } else {
                    Logger.getInstance(KeymapPanel.class).error("can't obtain application id from NSBundle");
                }
            }
        }

        JCheckBox getCheckbox() {
            return this.myCheckbox;
        }

        boolean isModified() {
            return this.myCheckbox == null ? false : this.myShowFnInitial != this.myCheckbox.isSelected();
        }

        void applyChanges() {
            if (!TouchBarsManager.isTouchBarAvailable() || this.myCheckbox == null || !this.isModified()) {
                return;
            }
            String appId = Utils.getAppId();
            if (appId == null || appId.isEmpty()) {
                Logger.getInstance(KeymapPanel.class).error("can't obtain application id from NSBundle");
                return;
            }
            boolean prevVal = this.myShowFnInitial;
            this.myShowFnInitial = this.myCheckbox.isSelected();
            NSDefaults.setShowFnKeysEnabled((String)appId, (boolean)this.myShowFnInitial);
            if (this.myShowFnInitial != NSDefaults.isShowFnKeysEnabled((String)appId)) {
                NSDefaults.setShowFnKeysEnabled((String)appId, (boolean)this.myShowFnInitial, (boolean)true);
                if (this.myShowFnInitial != NSDefaults.isShowFnKeysEnabled((String)appId)) {
                    return;
                }
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                boolean result2 = Utils.restartTouchBarServer();
                if (!result2) {
                    this.myShowFnInitial = prevVal;
                    NSDefaults.setShowFnKeysEnabled((String)appId, (boolean)this.myShowFnInitial);
                    if (!this.myDisposed) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!this.myDisposed) {
                                this.myCheckbox.setSelected(prevVal);
                            }
                        }, ModalityState.stateForComponent((Component)this.myCheckbox));
                    }
                }
            });
        }

        public void dispose() {
            if (!this.myDisposed) {
                this.myDisposed = true;
                this.myCheckbox = null;
            }
        }
    }
}

