/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import org.jetbrains.annotations.NotNull;

public class ActionShortcutRestrictionsImpl
extends ActionShortcutRestrictions {
    private static final ShortcutRestrictions MOUSE_SINGLE_CLICK_ONLY = new ShortcutRestrictions(true, true, false, false, false, false);
    private static final ShortcutRestrictions FIXED_SHORTCUT = new ShortcutRestrictions(false, false, false, false, false, false);
    private static final ShortcutRestrictions SWING_SHORTCUT = new ShortcutRestrictions(true, false, false, true, false, false);

    @Override
    @NotNull
    public ShortcutRestrictions getForActionId(String actionId) {
        if (actionId == null) {
            return ShortcutRestrictions.NO_RESTRICTIONS;
        }
        if (actionId.startsWith("Swing-")) {
            return SWING_SHORTCUT;
        }
        if ("EditorAddOrRemoveCaret".equals(actionId) || "EditorCreateRectangularSelection".equals(actionId) || "EditorAddRectangularSelectionOnMouseDrag".equals(actionId) || "EditorCreateRectangularSelectionOnMouseDrag".equals(actionId)) {
            return MOUSE_SINGLE_CLICK_ONLY;
        }
        if ("ExpandLiveTemplateByTab".equals(actionId)) {
            return FIXED_SHORTCUT;
        }
        return ShortcutRestrictions.NO_RESTRICTIONS;
    }
}

