/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.EmptyIcon;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class FileTypeRenderer
extends SimpleListCellRenderer<FileType> {
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    private static final Pattern CLEANUP = Pattern.compile("(?i)\\s+file(?:s)?$");
    private final FileTypeListProvider myFileTypeListProvider;

    public FileTypeRenderer() {
        this(new DefaultFileTypeListProvider());
    }

    public FileTypeRenderer(@NotNull FileTypeListProvider fileTypeListProvider) {
        this.myFileTypeListProvider = fileTypeListProvider;
    }

    public void customize(@NotNull JList<? extends FileType> list2, FileType value2, int index, boolean selected2, boolean hasFocus) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        Icon icon2 = value2.getIcon();
        if (icon2 != null) {
            layeredIcon.setIcon(icon2, 1, (-icon2.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon2.getIconHeight()) / 2);
        }
        this.setIcon((Icon)layeredIcon);
        String description = value2.getDescription();
        String trimmedDescription = StringUtil.capitalizeWords((String)CLEANUP.matcher(description).replaceAll(""), (boolean)true);
        if (this.isDuplicated(description)) {
            this.setText(trimmedDescription + " (" + value2.getName() + ")");
        } else {
            this.setText(trimmedDescription);
        }
    }

    private boolean isDuplicated(@NotNull String description) {
        boolean found = false;
        for (FileType type : this.myFileTypeListProvider.getCurrentFileTypeList()) {
            if (!description.equals(type.getDescription())) continue;
            if (!found) {
                found = true;
                continue;
            }
            return true;
        }
        return false;
    }

    private static class DefaultFileTypeListProvider
    implements FileTypeListProvider {
        private final List<FileType> myFileTypes = Arrays.asList(FileTypeManager.getInstance().getRegisteredFileTypes());

        private DefaultFileTypeListProvider() {
        }

        @Override
        @NotNull
        public Iterable<FileType> getCurrentFileTypeList() {
            return this.myFileTypes;
        }
    }

    public static interface FileTypeListProvider {
        @NotNull
        public Iterable<FileType> getCurrentFileTypeList();
    }
}

