/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeHint;
import com.intellij.openapi.fileTypes.impl.FileTypeHintPersistentComponent;
import com.intellij.openapi.fileTypes.impl.FileTypeHints;
import com.intellij.openapi.fileTypes.impl.FileTypeOverrider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/fileTypes/impl/FileTypeHintService;", "Lcom/intellij/openapi/fileTypes/impl/FileTypeOverrider;", "()V", "getOverriddenFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "matches", "", "Lcom/intellij/openapi/fileTypes/impl/FileTypeHint;", "intellij.platform.ide.impl"})
public final class FileTypeHintService
implements FileTypeOverrider {
    @Override
    @Nullable
    public FileType getOverriddenFileType(@NotNull VirtualFile file2) {
        if (file2 instanceof VirtualFileSystemEntry) {
            Project project = ProjectLocator.getInstance().guessProjectForFile(file2);
            if (project == null) {
                return null;
            }
            Project project2 = project;
            FileTypeHint textHint = ((FileTypeHints)FileTypeHintPersistentComponent.Companion.getInstance(project2).getState()).getText();
            if (this.matches(textHint, file2)) {
                return (FileType)PlainTextFileType.INSTANCE;
            }
            FileTypeHint ignoredHint = ((FileTypeHints)FileTypeHintPersistentComponent.Companion.getInstance(project2).getState()).getIgnored();
            if (this.matches(ignoredHint, file2)) {
                return UnknownFileType.INSTANCE;
            }
            return null;
        }
        return null;
    }

    private final boolean matches(FileTypeHint $this$matches, VirtualFile file2) {
        block8: {
            block7: {
                Object ext;
                Collection collection = $this$matches.getExtensions();
                boolean bl = false;
                if (!collection.isEmpty()) {
                    ext = file2.getExtension();
                    if (CollectionsKt.contains((Iterable)$this$matches.getExtensions(), (Object)ext)) {
                        return true;
                    }
                }
                ext = $this$matches.getNames();
                bl = false;
                if (!ext.isEmpty()) break block7;
                ext = $this$matches.getPrefixes();
                bl = false;
                if (!(!ext.isEmpty())) break block8;
            }
            CharSequence name = file2.getNameSequence();
            if (CollectionsKt.contains((Iterable)$this$matches.getNames(), (Object)name)) {
                return true;
            }
            for (String prefix : $this$matches.getPrefixes()) {
                if (!StringsKt.startsWith$default((CharSequence)name, (CharSequence)prefix, (boolean)false, (int)2, null)) continue;
                return true;
            }
        }
        return false;
    }
}

