/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

final class OpenFilesActivity
implements StartupActivity {
    OpenFilesActivity() {
    }

    public void runActivity(@NotNull Project project) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (!(fileEditorManager instanceof FileEditorManagerImpl)) {
            return;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(IdeBundle.message((String)"progress.text.reopening.files", (Object[])new Object[0]));
        }
        FileEditorManagerImpl manager = (FileEditorManagerImpl)fileEditorManager;
        EditorsSplitters editorSplitters = manager.getMainSplitters();
        Ref<JPanel> panelRef = editorSplitters.restoreEditors();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (panelRef != null) {
                editorSplitters.doOpenFiles((JPanel)panelRef.get());
            }
            manager.initDockableContentFactory();
            if (!manager.hasOpenFiles()) {
                EditorsSplitters.stopOpenFilesActivity(project);
                if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    if (Registry.is((String)"ide.open.readme.md.on.startup")) {
                        RunOnceUtil.runOnceForProject((Project)project, (String)"ShowReadmeOnStart", () -> OpenFilesActivity.findAndOpenReadme(project, manager));
                    }
                    if (Registry.is((String)"ide.open.project.view.on.startup")) {
                        RunOnceUtil.runOnceForProject((Project)project, (String)"OpenProjectViewOnStart", () -> OpenFilesActivity.openProjectView(project));
                    }
                }
            }
        }, project.getDisposed());
    }

    private static void findAndOpenReadme(@NotNull Project project, @NotNull FileEditorManagerImpl manager) {
        VirtualFile readme;
        VirtualFile dir = ProjectUtil.guessProjectDir((Project)project);
        if (dir != null && (readme = dir.findChild("README.md")) != null && !readme.isDirectory()) {
            readme.putUserData(TextEditorWithPreview.DEFAULT_LAYOUT_FOR_FILE, (Object)TextEditorWithPreview.Layout.SHOW_PREVIEW);
            ApplicationManager.getApplication().invokeLater(() -> manager.openFile(readme, true), project.getDisposed());
        }
    }

    private static void openProjectView(@NotNull Project project) {
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        manager.invokeLater(() -> {
            ToolWindow window;
            if (null == manager.getActiveToolWindowId() && (window = manager.getToolWindow("Project")) != null) {
                window.activate(null);
            }
        });
    }
}

