/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessDialog;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.project.ProjectKt;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonProjectFileWritingAccessProvider
extends WritingAccessProvider {
    private static final Key<Boolean> ENABLE_IN_TESTS = Key.create((String)"NON_PROJECT_FILE_ACCESS_ENABLE_IN_TESTS");
    private static final Key<Boolean> HONOUR_RECENT_FILES_IN_TESTS = Key.create((String)"NON_PROJECT_FILE_ACCESS_HONOUR_RECENT_FILES_IN_TESTS");
    private static final NotNullLazyKey<AtomicInteger, UserDataHolder> ACCESS_ALLOWED = NotNullLazyKey.create((String)"NON_PROJECT_FILE_ACCESS", holder -> new AtomicInteger());
    private static final AtomicBoolean myInitialized = new AtomicBoolean();
    @NotNull
    private final Project myProject;
    @Nullable
    private static NullableFunction<? super List<VirtualFile>, UnlockOption> ourCustomUnlocker;

    public static void setCustomUnlocker(@Nullable NullableFunction<? super List<VirtualFile>, UnlockOption> unlocker) {
        ourCustomUnlocker = unlocker;
    }

    public NonProjectFileWritingAccessProvider(@NotNull Project project) {
        this.myProject = project;
        if (myInitialized.compareAndSet(false, true)) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new OurVirtualFileListener());
        }
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files2) {
        if (NonProjectFileWritingAccessProvider.isAllAccessAllowed()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> deniedFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            if (NonProjectFileWritingAccessProvider.isWriteAccessAllowed(virtualFile, this.myProject)) continue;
            deniedFiles.add(virtualFile);
        }
        if (deniedFiles.isEmpty()) {
            return Collections.emptyList();
        }
        UnlockOption unlockOption = this.askToUnlock(deniedFiles);
        if (unlockOption == null) {
            return deniedFiles;
        }
        switch (unlockOption) {
            case UNLOCK: {
                NonProjectFileWritingAccessProvider.allowWriting(deniedFiles);
                break;
            }
            case UNLOCK_DIR: {
                NonProjectFileWritingAccessProvider.allowWriting(ContainerUtil.map(deniedFiles, VirtualFile::getParent));
                break;
            }
            case UNLOCK_ALL: {
                ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)NonProjectFileWritingAccessProvider.getApp())).incrementAndGet();
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private UnlockOption askToUnlock(@NotNull List<VirtualFile> files2) {
        if (ourCustomUnlocker != null) {
            return (UnlockOption)((Object)ourCustomUnlocker.fun(files2));
        }
        NonProjectFileWritingAccessDialog dialog2 = new NonProjectFileWritingAccessDialog(this.myProject, files2);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2.getUnlockOption();
    }

    public static boolean isWriteAccessAllowed(@NotNull VirtualFile file2, @NotNull Project project) {
        IdeDocumentHistoryImpl documentHistory;
        if (LightEdit.owns((Project)project)) {
            return true;
        }
        if (NonProjectFileWritingAccessProvider.isAllAccessAllowed()) {
            return true;
        }
        if (file2.isDirectory()) {
            return true;
        }
        if (!(file2.getFileSystem() instanceof LocalFileSystem)) {
            return true;
        }
        if (file2.getFileSystem() instanceof TempFileSystem) {
            return true;
        }
        Application application = NonProjectFileWritingAccessProvider.getApp();
        boolean unitTestMode = application.isUnitTestMode();
        if ((!unitTestMode || HONOUR_RECENT_FILES_IN_TESTS.get((UserDataHolder)application) == Boolean.TRUE) && (documentHistory = (IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(project)).isRecentlyChanged(file2)) {
            return true;
        }
        if (!unitTestMode && FileUtil.isAncestor((File)new File(FileUtil.getTempDirectory()), (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (boolean)true)) {
            return true;
        }
        for (VirtualFile each = file2; each != null; each = each.getParent()) {
            if (((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)each)).get() <= 0) continue;
            return true;
        }
        return NonProjectFileWritingAccessProvider.isProjectFile(file2, project);
    }

    private static boolean isProjectFile(@NotNull VirtualFile file2, @NotNull Project project) {
        for (NonProjectFileWritingAccessExtension each : (NonProjectFileWritingAccessExtension[])NonProjectFileWritingAccessExtension.EP_NAME.getExtensions((AreaInstance)project)) {
            if (each.isWritable(file2)) {
                return true;
            }
            if (!each.isNotWritable(file2)) continue;
            return false;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        if (fileIndex.isInContent(file2)) {
            return true;
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && fileIndex.isExcluded(file2) && !fileIndex.isUnderIgnored(file2)) {
            return true;
        }
        if (project instanceof ProjectEx && !project.isDefault()) {
            if (ProjectKt.getStateStore(project).isProjectFile(file2)) {
                return true;
            }
            String filePath = file2.getPath();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (!FileUtil.namesEqual((String)filePath, (String)module.getModuleFilePath())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static void allowWriting(VirtualFile ... allowedFiles) {
        NonProjectFileWritingAccessProvider.allowWriting(Arrays.asList(allowedFiles));
    }

    public static void allowWriting(Iterable<? extends VirtualFile> allowedFiles) {
        for (VirtualFile virtualFile : allowedFiles) {
            ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)virtualFile)).incrementAndGet();
        }
    }

    public static void disableChecksDuring(@NotNull Runnable runnable2) {
        Application app = NonProjectFileWritingAccessProvider.getApp();
        ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).incrementAndGet();
        try {
            runnable2.run();
        }
        finally {
            ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).decrementAndGet();
        }
    }

    public static void enableChecksInTests(@NotNull Disposable disposable2) {
        NonProjectFileWritingAccessProvider.enableChecksInTests(false, disposable2);
    }

    public static void enableChecksInTests(@Nullable Boolean honourRecentFiles, @NotNull Disposable disposable2) {
        NonProjectFileWritingAccessProvider.getApp().putUserData(ENABLE_IN_TESTS, (Object)Boolean.TRUE);
        NonProjectFileWritingAccessProvider.getApp().putUserData(HONOUR_RECENT_FILES_IN_TESTS, (Object)honourRecentFiles);
        NonProjectFileWritingAccessProvider.getApp().putUserData(ACCESS_ALLOWED, null);
        Disposer.register((Disposable)disposable2, () -> {
            NonProjectFileWritingAccessProvider.getApp().putUserData(ENABLE_IN_TESTS, null);
            NonProjectFileWritingAccessProvider.getApp().putUserData(HONOUR_RECENT_FILES_IN_TESTS, null);
            NonProjectFileWritingAccessProvider.getApp().putUserData(ACCESS_ALLOWED, null);
        });
    }

    private static boolean isAllAccessAllowed() {
        Application app = NonProjectFileWritingAccessProvider.getApp();
        if (app.isUnitTestMode() && app.getUserData(ENABLE_IN_TESTS) != Boolean.TRUE) {
            return true;
        }
        return ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).get() > 0;
    }

    private static Application getApp() {
        return ApplicationManager.getApplication();
    }

    private static class OurVirtualFileListener
    implements VirtualFileListener {
        private OurVirtualFileListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            OurVirtualFileListener.unlock(event);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            OurVirtualFileListener.unlock((VirtualFileEvent)event);
        }

        private static void unlock(@NotNull VirtualFileEvent event) {
            if (!event.isFromRefresh() && !event.getFile().isDirectory()) {
                NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(event.getFile()));
            }
        }
    }

    public static enum UnlockOption {
        UNLOCK,
        UNLOCK_DIR,
        UNLOCK_ALL;

    }
}

