/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.DefaultPlatformFileEditorProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileEditorProviderManager", storages={@Storage(value="fileEditorProviderManager.xml", roamingType=RoamingType.DISABLED)})
public final class FileEditorProviderManagerImpl
extends FileEditorProviderManager
implements PersistentStateComponent<FileEditorProviderManagerImpl> {
    private final Map<String, String> mySelectedProviders = new HashMap<String, String>();

    @Override
    public FileEditorProvider @NotNull [] getProviders(@NotNull Project project, @NotNull VirtualFile file2) {
        ArrayList<FileEditorProvider> sharedProviders = new ArrayList<FileEditorProvider>();
        boolean hideDefaultEditor = false;
        for (FileEditorProvider provider2 : FileEditorProvider.EP_FILE_EDITOR_PROVIDER.getExtensionList()) {
            if (!((Boolean)ReadAction.compute(() -> {
                if (DumbService.isDumb((Project)project) && !DumbService.isDumbAware((Object)provider2)) {
                    return false;
                }
                return provider2.accept(project, file2);
            })).booleanValue()) continue;
            sharedProviders.add(provider2);
            hideDefaultEditor |= provider2.getPolicy() == FileEditorPolicy.HIDE_DEFAULT_EDITOR;
            if (provider2.getPolicy() != FileEditorPolicy.HIDE_DEFAULT_EDITOR || DumbService.isDumbAware((Object)provider2)) continue;
            String message = "HIDE_DEFAULT_EDITOR is supported only for DumbAware providers; " + provider2.getClass() + " is not DumbAware.";
            Logger.getInstance(FileEditorProviderManagerImpl.class).error((Throwable)PluginException.createByClass((String)message, null, provider2.getClass()));
        }
        if (hideDefaultEditor) {
            ContainerUtil.retainAll(sharedProviders, provider -> !(provider instanceof DefaultPlatformFileEditorProvider));
        }
        sharedProviders.sort(MyComparator.ourInstance);
        return sharedProviders.toArray(new FileEditorProvider[0]);
    }

    @Override
    @Nullable
    public FileEditorProvider getProvider(@NotNull String editorTypeId) {
        for (FileEditorProvider provider : FileEditorProvider.EP_FILE_EDITOR_PROVIDER.getExtensionList()) {
            if (!provider.getEditorTypeId().equals(editorTypeId)) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public FileEditorProviderManagerImpl getState() {
        return this;
    }

    public void loadState(@NotNull FileEditorProviderManagerImpl state) {
        this.mySelectedProviders.clear();
        this.mySelectedProviders.putAll(state.mySelectedProviders);
    }

    void providerSelected(@NotNull EditorComposite composite) {
        FileEditorProvider[] providers = composite.getProviders();
        if (providers.length < 2) {
            return;
        }
        this.mySelectedProviders.put(FileEditorProviderManagerImpl.computeKey(providers), composite.getSelectedWithProvider().getProvider().getEditorTypeId());
    }

    @NotNull
    private static String computeKey(FileEditorProvider[] providers) {
        return StringUtil.join((Collection)ContainerUtil.map((Object[])providers, FileEditorProvider::getEditorTypeId), (String)",");
    }

    @Nullable
    FileEditorProvider getSelectedFileEditorProvider(@NotNull EditorHistoryManager editorHistoryManager, @NotNull VirtualFile file2, FileEditorProvider @NotNull [] providers) {
        FileEditorProvider provider = editorHistoryManager.getSelectedProvider(file2);
        if (provider != null || providers.length < 2) {
            return provider;
        }
        String id2 = this.mySelectedProviders.get(FileEditorProviderManagerImpl.computeKey(providers));
        return id2 == null ? null : this.getProvider(id2);
    }

    @MapAnnotation
    public Map<String, String> getSelectedProviders() {
        return this.mySelectedProviders;
    }

    public void setSelectedProviders(Map<String, String> selectedProviders) {
        this.mySelectedProviders.clear();
        this.mySelectedProviders.putAll(selectedProviders);
    }

    public void clearSelectedProviders() {
        this.mySelectedProviders.clear();
    }

    private static final class MyComparator
    implements Comparator<FileEditorProvider> {
        public static final MyComparator ourInstance = new MyComparator();

        private MyComparator() {
        }

        private static double getWeight(FileEditorProvider provider) {
            return provider instanceof WeighedFileEditorProvider ? ((WeighedFileEditorProvider)provider).getWeight() : Double.MAX_VALUE;
        }

        @Override
        public int compare(FileEditorProvider provider1, FileEditorProvider provider2) {
            int c = provider1.getPolicy().compareTo((Enum)provider2.getPolicy());
            if (c != 0) {
                return c;
            }
            double value2 = MyComparator.getWeight(provider1) - MyComparator.getWeight(provider2);
            return value2 > 0.0 ? 1 : (value2 < 0.0 ? -1 : 0);
        }
    }
}

