/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ui.update.Activatable;
import java.awt.Image;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockableEditorTabbedContainer
implements DockContainer.Persistent,
Activatable {
    private final EditorsSplitters mySplitters;
    private final Project myProject;
    private final CopyOnWriteArraySet<DockContainer.Listener> myListeners = new CopyOnWriteArraySet();
    private JBTabs myCurrentOver;
    private Image myCurrentOverImg;
    private TabInfo myCurrentOverInfo;
    private final boolean myDisposeWhenEmpty;
    private boolean myWasEverShown;

    DockableEditorTabbedContainer(Project project) {
        this(project, null, true);
    }

    DockableEditorTabbedContainer(Project project, @Nullable EditorsSplitters splitters, boolean disposeWhenEmpty) {
        this.myProject = project;
        this.mySplitters = splitters;
        this.myDisposeWhenEmpty = disposeWhenEmpty;
    }

    public String getDockContainerType() {
        return "file-editors";
    }

    public Element getState() {
        Element editors = new Element("state");
        this.mySplitters.writeExternal(editors);
        return editors;
    }

    void fireContentClosed(@NotNull VirtualFile file2) {
        for (DockContainer.Listener each : this.myListeners) {
            each.contentRemoved((Object)file2);
        }
    }

    void fireContentOpen(@NotNull VirtualFile file2) {
        for (DockContainer.Listener each : this.myListeners) {
            each.contentAdded((Object)file2);
        }
    }

    @NotNull
    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle((JComponent)((Object)this.mySplitters));
    }

    @NotNull
    public RelativeRectangle getAcceptAreaFallback() {
        JRootPane root = this.mySplitters.getRootPane();
        return root != null ? new RelativeRectangle((JComponent)root) : new RelativeRectangle((JComponent)((Object)this.mySplitters));
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content2, RelativePoint point) {
        return this.getTabsAt(content2, point) != null ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
    }

    @Nullable
    private JBTabs getTabsAt(DockableContent<?> content2, RelativePoint point) {
        EditorWindow[] windows;
        if (!(content2 instanceof EditorTabbedContainer.DockableEditor)) {
            return null;
        }
        JBTabs targetTabs = this.mySplitters.getTabsAt(point);
        if (targetTabs != null) {
            return targetTabs;
        }
        EditorWindow window = this.mySplitters.getCurrentWindow();
        if (window != null) {
            return window.getTabbedPane().getTabs();
        }
        for (EditorWindow each : windows = this.mySplitters.getWindows()) {
            if (each.getTabbedPane().getTabs() == null) continue;
            return each.getTabbedPane().getTabs();
        }
        return null;
    }

    public void add(@NotNull DockableContent content2, RelativePoint dropTarget) {
        DataProvider provider;
        EditorWindow window = null;
        if (this.myCurrentOver != null && (provider = this.myCurrentOver.getDataProvider()) != null) {
            window = (EditorWindow)EditorWindow.DATA_KEY.getData(provider);
        }
        EditorTabbedContainer.DockableEditor dockableEditor = (EditorTabbedContainer.DockableEditor)content2;
        VirtualFile file2 = dockableEditor.getFile();
        if (window == null || window.isDisposed()) {
            window = this.mySplitters.getOrCreateCurrentWindow(file2);
        }
        if (this.myCurrentOver != null) {
            int index = ((JBTabsEx)this.myCurrentOver).getDropInfoIndex();
            file2.putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)index);
        }
        ((FileEditorManagerImpl)FileEditorManagerEx.getInstanceEx(this.myProject)).openFileImpl2(window, file2, true);
        window.setFilePinned(file2, dockableEditor.isPinned());
    }

    public Image processDropOver(@NotNull DockableContent content2, RelativePoint point) {
        JBTabs current2 = this.getTabsAt(content2, point);
        if (this.myCurrentOver != null && this.myCurrentOver != current2) {
            this.resetDropOver(content2);
        }
        if (this.myCurrentOver == null && current2 != null) {
            this.myCurrentOver = current2;
            Presentation presentation2 = content2.getPresentation();
            this.myCurrentOverInfo = new TabInfo((JComponent)new JLabel("")).setText(presentation2.getText()).setIcon(presentation2.getIcon());
            this.myCurrentOverImg = this.myCurrentOver.startDropOver(this.myCurrentOverInfo, point);
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.processDropOver(this.myCurrentOverInfo, point);
        }
        return this.myCurrentOverImg;
    }

    public void resetDropOver(@NotNull DockableContent content2) {
        if (this.myCurrentOver != null) {
            this.myCurrentOver.resetDropOver(this.myCurrentOverInfo);
            this.myCurrentOver = null;
            this.myCurrentOverInfo = null;
            this.myCurrentOverImg = null;
        }
    }

    public JComponent getContainerComponent() {
        return this.mySplitters;
    }

    public EditorsSplitters getSplitters() {
        return this.mySplitters;
    }

    public void close(@NotNull VirtualFile file2) {
        this.mySplitters.closeFile(file2, false);
    }

    public void closeAll() {
        for (VirtualFile each : this.mySplitters.getOpenFileList()) {
            this.close(each);
        }
    }

    public void addListener(final @NotNull DockContainer.Listener listener2, Disposable parent) {
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DockableEditorTabbedContainer.this.myListeners.remove(listener2);
            }
        });
    }

    public boolean isEmpty() {
        return this.mySplitters.isEmptyVisible();
    }

    public boolean isDisposeWhenEmpty() {
        return this.myDisposeWhenEmpty;
    }

    public void showNotify() {
        if (!this.myWasEverShown) {
            this.myWasEverShown = true;
            this.getSplitters().openFiles();
        }
    }
}

