/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSaverDialogImpl
extends FileChooserDialogImpl
implements FileSaverDialog {
    protected final JTextField myFileName = new JTextField(20);
    protected final JComboBox myExtensions = new JComboBox();
    protected final FileSaverDescriptor myDescriptor;

    public FileSaverDialogImpl(@NotNull FileSaverDescriptor descriptor2, @NotNull Component parent) {
        super((FileChooserDescriptor)descriptor2, parent);
        this.myDescriptor = descriptor2;
        for (String ext : descriptor2.getFileExtensions()) {
            this.myExtensions.addItem(ext);
        }
        this.setTitle(FileSaverDialogImpl.getChooserTitle(descriptor2));
    }

    public FileSaverDialogImpl(@NotNull FileSaverDescriptor descriptor2, @Nullable Project project) {
        super((FileChooserDescriptor)descriptor2, project);
        this.myDescriptor = descriptor2;
        for (String ext : descriptor2.getFileExtensions()) {
            this.myExtensions.addItem(ext);
        }
        this.setTitle(FileSaverDialogImpl.getChooserTitle(descriptor2));
    }

    private static String getChooserTitle(FileSaverDescriptor descriptor2) {
        String title = descriptor2.getTitle();
        return title != null ? title : UIBundle.message((String)"file.chooser.save.dialog.default.title", (Object[])new Object[0]);
    }

    @Nullable
    public VirtualFileWrapper save(@Nullable VirtualFile baseDir, @Nullable String filename) {
        this.init();
        this.restoreSelection(baseDir);
        this.myFileSystemTree.addListener(new FileSystemTree.Listener(){

            public void selectionChanged(@NotNull List<? extends VirtualFile> selection) {
                FileSaverDialogImpl.this.updateFileName(selection);
                FileSaverDialogImpl.this.updateOkButton();
            }
        }, this.myDisposable);
        if (filename != null) {
            this.myFileName.setText(filename);
        }
        this.show();
        if (this.getExitCode() == 0) {
            File file2 = this.getFile();
            return file2 == null ? null : new VirtualFileWrapper(file2);
        }
        return null;
    }

    @Nullable
    protected File getFile() {
        String selectedExtension;
        VirtualFile selected2 = this.myFileSystemTree.getSelectedFile();
        if (selected2 != null && !selected2.isDirectory()) {
            return new File(selected2.getPath());
        }
        String path = selected2 == null ? this.myPathTextField.getTextFieldText() : selected2.getPath();
        File dir = new File(path);
        if (!dir.exists()) {
            return null;
        }
        if (dir.isDirectory()) {
            path = path + File.separator + this.myFileName.getText();
        }
        boolean correctExt = true;
        for (String ext : this.myDescriptor.getFileExtensions()) {
            correctExt = path.endsWith("." + ext);
            if (correctExt) break;
        }
        if (!correctExt && !StringUtil.isEmpty((String)(selectedExtension = (String)ObjectUtils.doIfNotNull((Object)this.myExtensions.getSelectedItem(), item -> item.toString())))) {
            path = path + "." + selectedExtension;
        }
        return new File(path);
    }

    private void updateFileName(List<? extends VirtualFile> selection) {
        for (VirtualFile virtualFile : selection) {
            if (virtualFile.isDirectory()) {
                this.myPathTextField.getField().setText(VfsUtil.getReadableUrl((VirtualFile)virtualFile));
                continue;
            }
            this.myFileName.setText(virtualFile.getName());
            VirtualFile parent = virtualFile.getParent();
            if (parent == null) continue;
            this.myPathTextField.getField().setText(VfsUtil.getReadableUrl((VirtualFile)parent));
        }
        this.updateOkButton();
    }

    @Override
    protected JComponent createCenterPanel() {
        JComponent component2 = super.createCenterPanel();
        FileChooserDialogImpl.MyPanel panel2 = new FileChooserDialogImpl.MyPanel();
        panel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel2.add((Component)component2, "Center");
        panel2.add((Component)this.createFileNamePanel(), "South");
        return panel2;
    }

    protected JComponent createFileNamePanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JLabel(UIBundle.message((String)"file.chooser.save.dialog.file.name", (Object[])new Object[0])), "West");
        this.myFileName.setText("");
        this.myFileName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                FileSaverDialogImpl.this.updateOkButton();
            }
        });
        panel2.add((Component)this.myFileName, "Center");
        if (this.myExtensions.getModel().getSize() > 0) {
            this.myExtensions.setSelectedIndex(0);
            panel2.add((Component)this.myExtensions, "East");
        }
        return panel2;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myFileName;
    }

    private boolean isFileNameExist() {
        if (this.myPathTextField == null) {
            return false;
        }
        String path = this.myPathTextField.getTextFieldText();
        return path != null && new File(path.trim()).exists() && this.myFileName.getText().trim().length() > 0;
    }

    protected void updateOkButton() {
        this.setOKActionEnabled(true);
    }

    public void setOKActionEnabled(boolean isEnabled) {
        super.setOKActionEnabled(this.isFileNameExist());
    }

    @Override
    protected void doOKAction() {
        File file2 = this.getFile();
        if (file2 != null && file2.exists() && 0 != Messages.showYesNoDialog((Component)this.getRootPane(), (String)UIBundle.message((String)"file.chooser.save.dialog.confirmation", (Object[])new Object[]{file2.getName()}), (String)UIBundle.message((String)"file.chooser.save.dialog.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) {
            return;
        }
        this.storeSelection(this.myFileSystemTree.getSelectedFile());
        super.doOKAction();
    }
}

