/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileType;
import com.intellij.openapi.file.exclude.PersistentFileSetManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.util.indexing.FileBasedIndex;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectPlainTextFileTypeManager")
public class ProjectPlainTextFileTypeManager
extends PersistentFileSetManager {
    @NotNull
    private final Project myProject;

    public ProjectPlainTextFileTypeManager(@NotNull Project project) {
        this.myProject = project;
    }

    public static ProjectPlainTextFileTypeManager getInstance(@NotNull Project project) {
        return (ProjectPlainTextFileTypeManager)project.getService(ProjectPlainTextFileTypeManager.class);
    }

    @Override
    protected void onFileAdded(@NotNull VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (FileTypeIndex.getIndexedFileType((VirtualFile)file2, (Project)this.myProject) != EnforcedPlainTextFileType.INSTANCE) {
            FileBasedIndex.getInstance().requestReindex(file2);
        }
    }

    @Override
    protected void onFileRemoved(@NotNull VirtualFile file2) {
        FileBasedIndex.getInstance().requestReindex(file2);
    }
}

