/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskNode
extends ExternalSystemNode<TaskData> {
    private final TaskData myTaskData;
    private String moduleOwnerName;

    public TaskNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull DataNode<TaskData> dataNode) {
        super(externalProjectsView, null, dataNode);
        this.myTaskData = (TaskData)dataNode.getData();
        DataNode parent = ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.MODULE);
        if (parent == null) {
            parent = ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.PROJECT);
        }
        if (parent != null && parent.getData() instanceof Named) {
            this.moduleOwnerName = ((Named)parent.getData()).getInternalName();
        }
    }

    protected void update(@NotNull PresentationData presentation2) {
        super.update(presentation2);
        presentation2.setIcon(this.getUiAware().getTaskIcon());
        String shortcutHint = StringUtil.nullize((String)this.getShortcutsManager().getDescription(this.myTaskData.getLinkedExternalProjectPath(), this.myTaskData.getName()));
        String activatorHint = StringUtil.nullize((String)this.getTaskActivator().getDescription(this.myTaskData.getOwner(), this.myTaskData.getLinkedExternalProjectPath(), this.myTaskData.getName()));
        String hint = shortcutHint == null ? activatorHint : (activatorHint == null ? shortcutHint : shortcutHint + ", " + activatorHint);
        this.setNameAndTooltip(this.getName(), this.myTaskData.getDescription(), hint);
    }

    @Override
    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        return !this.myTaskData.isInherited() || this.getExternalProjectsView().showInheritedTasks();
    }

    public boolean isTest() {
        return this.myTaskData.isTest();
    }

    public String getModuleOwnerName() {
        return this.moduleOwnerName;
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.TaskMenu";
    }

    @Override
    @Nullable
    protected String getActionId() {
        return "ExternalSystem.RunTask";
    }

    public boolean isAlwaysLeaf() {
        return true;
    }
}

