/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    protected AbstractExternalSystemToolWindowFactory(@NotNull ProjectSystemId id2) {
        this.myExternalSystemId = id2;
    }

    public boolean isApplicable(@NotNull Project project) {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.myExternalSystemId);
        AbstractExternalSystemSettings settings = manager == null ? null : (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
        return settings != null && !settings.getLinkedProjectsSettings().isEmpty();
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        toolWindow.setTitle(this.myExternalSystemId.getReadableName());
        ContentManager contentManager2 = toolWindow.getContentManager();
        contentManager2.addContent((Content)new ContentImpl(this.createInitializingLabel(), "", false));
        ExternalProjectsManager.getInstance((Project)project).runWhenInitialized(() -> {
            ExternalProjectsViewImpl projectsView = new ExternalProjectsViewImpl(project, (ToolWindowEx)toolWindow, this.myExternalSystemId);
            ExternalProjectsManagerImpl.getInstance(project).registerView(projectsView);
            ContentImpl tasksContent = new ContentImpl((JComponent)((Object)projectsView), "", true);
            contentManager2.removeAllContents(true);
            contentManager2.addContent((Content)tasksContent);
        });
    }

    @NotNull
    private JLabel createInitializingLabel() {
        JLabel label2 = new JLabel(ExternalSystemBundle.message((String)"initializing.0.projects.data", (Object[])new Object[]{this.myExternalSystemId.getReadableName()}), 0);
        label2.setOpaque(true);
        return label2;
    }
}

