/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.DeduplicateVisitorsSupplier;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManagerImpl
implements ProjectDataManager {
    private static final Logger LOG = Logger.getInstance(ProjectDataManagerImpl.class);
    private static final Function<ProjectDataService<?, ?>, Key<?>> KEY_MAPPER = ProjectDataService::getTargetDataKey;

    public static ProjectDataManagerImpl getInstance() {
        ProjectDataManager service = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        return (ProjectDataManagerImpl)service;
    }

    @NotNull
    public List<ProjectDataService<?, ?>> findService(@NotNull Key<?> key) {
        ArrayList result2 = new ArrayList(ProjectDataService.EP_NAME.getByGroupingKey(key, ProjectDataManagerImpl.class, KEY_MAPPER));
        ExternalSystemApiUtil.orderAwareSort(result2);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        PerformanceTrace trace;
        ProjectSystemId projectSystemId;
        ProjectData projectData2;
        if (project.isDisposed()) {
            return;
        }
        MultiMap grouped = ExternalSystemApiUtil.recursiveGroup(nodes);
        Collection projects = grouped.get((Object)ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode projectNode = (DataNode)ContainerUtil.getFirstItem((Collection)projects);
        if (projectNode != null) {
            projectData2 = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project).saveInclusionSettings((DataNode<ProjectData>)projectNode);
        } else {
            projectData2 = null;
            DataNode aModuleNode = (DataNode)ContainerUtil.getFirstItem((Collection)grouped.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project, projectSystemId);
        }
        SmartList onSuccessImportTasks = new SmartList();
        SmartList onFailureImportTasks = new SmartList();
        Collection traceNodes = grouped.get(PerformanceTrace.TRACE_NODE_KEY);
        if (traceNodes.size() > 0) {
            trace = (PerformanceTrace)((DataNode)traceNodes.iterator().next()).getData();
        } else {
            trace = new PerformanceTrace();
            grouped.putValue(PerformanceTrace.TRACE_NODE_KEY, (Object)new DataNode(PerformanceTrace.TRACE_NODE_KEY, (Object)trace, null));
        }
        long allStartTime = System.currentTimeMillis();
        try {
            TreeSet allKeys = new TreeSet(grouped.keySet());
            ProjectDataService.EP_NAME.forEachExtensionSafe(dataService -> allKeys.add(dataService.getTargetDataKey()));
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            int size = allKeys.size();
            int count = 0;
            SmartList postImportTasks = new SmartList();
            for (Key key : allKeys) {
                if (indicator != null) {
                    String message = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", ExternalSystemBundle.message((String)"progress.update.refresh", (Object[])new Object[]{ProjectDataManagerImpl.getReadableText(key)})});
                    indicator.setText(message);
                    indicator.setFraction((double)count++ / (double)size);
                }
                long startTime = System.currentTimeMillis();
                this.doImportData(key, grouped.get((Object)key), projectData2, project, modelsProvider, (List<Runnable>)postImportTasks, (List<Runnable>)onSuccessImportTasks, (List<Runnable>)onFailureImportTasks);
                trace.logPerformance("Data import by " + key.toString(), System.currentTimeMillis() - startTime);
            }
            for (Runnable postImportTask : postImportTasks) {
                postImportTask.run();
            }
            ProjectDataManagerImpl.commit(modelsProvider, project, synchronous, "Imported data");
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            ((ProjectDataImportListener)project.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC)).onImportFinished(projectData2 != null ? projectData2.getLinkedExternalProjectPath() : null);
            trace.logPerformance("Data import total", System.currentTimeMillis() - allStartTime);
        }
        catch (Throwable t) {
            try {
                ProjectDataManagerImpl.runFinalTasks(project, synchronous, (List<Runnable>)onFailureImportTasks);
                ProjectDataManagerImpl.dispose(modelsProvider, project, synchronous);
            }
            finally {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
            }
        }
        ProjectDataManagerImpl.runFinalTasks(project, synchronous, (List<Runnable>)onSuccessImportTasks);
    }

    private static void runFinalTasks(@NotNull Project project, boolean synchronous, final List<Runnable> tasks) {
        DisposeAwareProjectChange runnable2 = new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                for (Runnable task2 : ContainerUtil.reverse((List)tasks)) {
                    task2.run();
                }
            }
        };
        if (synchronous) {
            try {
                runnable2.run();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        } else {
            ApplicationManager.getApplication().invokeLater((Runnable)runnable2);
        }
    }

    @NotNull
    private static String getReadableText(@NotNull Key<?> key) {
        StringBuilder buffer = new StringBuilder();
        String s = key.toString();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char currChar = s.charAt(i2);
            if (Character.isUpperCase(currChar)) {
                if (i2 != 0) {
                    buffer.append(' ');
                }
                buffer.append(StringUtil.toLowerCase((char)currChar));
                continue;
            }
            buffer.append(currChar);
        }
        return buffer.toString();
    }

    public <T> void importData(@NotNull Collection<DataNode<T>> nodes, @NotNull Project project, boolean synchronous) {
        SmartList dummy = new SmartList();
        dummy.addAll(nodes);
        this.importData((Collection<DataNode<?>>)dummy, project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project), synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        SmartList dummy = new SmartList();
        dummy.add(node);
        this.importData((Collection<DataNode<?>>)dummy, project, modelsProvider, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, boolean synchronous) {
        this.importData(node, project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project), synchronous);
    }

    private <T> void doImportData(@NotNull Key<T> key, @NotNull Collection<DataNode<?>> nodes, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull List<Runnable> postImportTasks, @NotNull List<Runnable> onSuccessImportTasks, @NotNull List<Runnable> onFailureImportTasks) {
        if (project.isDisposed()) {
            return;
        }
        SmartList toImport = new SmartList();
        SmartList toIgnore = new SmartList();
        for (DataNode<?> node : nodes) {
            if (!key.equals((Object)node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse((Collection<DataNode<?>>)toImport);
        @NotNull List<ProjectDataService<?, ?>> services = this.findService(key);
        if (services.isEmpty()) {
            LOG.debug(String.format("No data service is registered for %s", key));
        } else {
            for (ProjectDataService<?, ?> service : services) {
                long importStartTime = System.currentTimeMillis();
                service.importData((Collection)toImport, projectData2, project, modifiableModelsProvider);
                if (LOG.isDebugEnabled()) {
                    long importTimeInMs = System.currentTimeMillis() - importStartTime;
                    LOG.debug(String.format("Service %s imported data in %d ms", service.getClass().getSimpleName(), importTimeInMs));
                }
                if (projectData2 == null) continue;
                this.ensureTheDataIsReadyToUse((Collection<DataNode<?>>)toIgnore);
                long removeStartTime = System.currentTimeMillis();
                Computable orphanIdeDataComputable = service.computeOrphanData((Collection)toImport, projectData2, project, modifiableModelsProvider);
                service.removeData(orphanIdeDataComputable, (Collection)toIgnore, projectData2, project, modifiableModelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s computed and removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
        }
        if (!services.isEmpty() && projectData2 != null) {
            postImportTasks.add(() -> ProjectDataManagerImpl.lambda$doImportData$1(services, (Collection)toImport, projectData2, project, modifiableModelsProvider));
            onFailureImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    long taskStartTime = System.currentTimeMillis();
                    service.onFailureImport(project);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run failure import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onSuccessImportTasks.add(() -> ProjectDataManagerImpl.lambda$doImportData$3(project, services, (Collection)toImport, projectData2));
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode startNode) {
        if (startNode == null || startNode.isReady()) {
            return;
        }
        DeduplicateVisitorsSupplier supplier2 = new DeduplicateVisitorsSupplier();
        startNode.visit(dataNode -> {
            if (dataNode.validateData()) {
                dataNode.visitData(supplier2.getVisitor(dataNode.getKey()));
            }
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove2, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        try {
            List<ProjectDataService<?, ?>> services = this.findService(key);
            for (ProjectDataService<?, ?> service : services) {
                long removeStartTime = System.currentTimeMillis();
                service.removeData((Computable)new Computable.PredefinedValueComputable(toRemove2), toIgnore, projectData2, project, modelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
            ProjectDataManagerImpl.commit(modelsProvider, project, synchronous, "Removed data");
        }
        catch (Throwable t) {
            ProjectDataManagerImpl.dispose(modelsProvider, project, synchronous);
            ExceptionUtil.rethrow((Throwable)t);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove2, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData2, @NotNull Project project, boolean synchronous) {
        this.removeData(key, toRemove2, toIgnore, projectData2, project, new IdeModifiableModelsProviderImpl(project), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (!project.isDisposed()) {
            ExternalProjectsManagerImpl.getInstance(project).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        return !project.isDisposed() ? ExternalProjectsDataStorage.getInstance(project).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId) {
        if (!project.isDisposed()) {
            return ExternalProjectsDataStorage.getInstance(project).list(projectSystemId);
        }
        return ContainerUtil.emptyList();
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<?>> nodes) {
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private static void commit(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, boolean synchronous, final @NotNull String commitDesc) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                long startTime = System.currentTimeMillis();
                modelsProvider.commit();
                long timeInMs = System.currentTimeMillis() - startTime;
                LOG.debug(String.format("%s committed in %d ms", commitDesc, timeInMs));
            }
        });
    }

    private static void dispose(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, boolean synchronous) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }

    private static /* synthetic */ void lambda$doImportData$3(Project project, List services, Collection toImport, ProjectData projectData2) {
        IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project);
        for (ProjectDataService service : services) {
            long taskStartTime = System.currentTimeMillis();
            service.onSuccessImport(toImport, projectData2, project, (IdeModelsProvider)modelsProvider);
            if (!LOG.isDebugEnabled()) continue;
            long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
            LOG.debug(String.format("Service %s run success import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
        }
    }

    private static /* synthetic */ void lambda$doImportData$1(List services, Collection toImport, ProjectData projectData2, Project project, IdeModifiableModelsProvider modifiableModelsProvider) {
        for (ProjectDataService service : services) {
            long taskStartTime = System.currentTimeMillis();
            service.postProcess(toImport, projectData2, project, modifiableModelsProvider);
            if (!LOG.isDebugEnabled()) continue;
            long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
            LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
        }
    }
}

