/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalLibraryPathTypeMapper;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectStructureUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483628)
public final class LibraryDataService
extends AbstractProjectDataService<LibraryData, Library> {
    private static final Logger LOG = Logger.getInstance(LibraryDataService.class);
    @NotNull
    public static final NotNullFunction<String, File> PATH_TO_FILE = path -> new File((String)path);

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        return ProjectKeys.LIBRARY;
    }

    public void importData(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        HashMap<String, LibraryData> processedLibraries = new HashMap<String, LibraryData>();
        for (DataNode<LibraryData> dataNode : toImport) {
            LibraryData libraryData = (LibraryData)dataNode.getData();
            String libraryName = libraryData.getInternalName();
            LibraryData importedLibrary = processedLibraries.putIfAbsent(libraryName, libraryData);
            if (importedLibrary == null) {
                this.importLibrary(libraryData, modelsProvider);
                continue;
            }
            LOG.warn("Multiple project level libraries found with the same name '" + libraryName + "'");
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Chosen library:" + importedLibrary.getPaths(LibraryPathType.BINARY));
            LOG.debug("Ignored library:" + libraryData.getPaths(LibraryPathType.BINARY));
        }
    }

    private void importLibrary(@NotNull LibraryData toImport, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Map<OrderRootType, Collection<File>> libraryFiles = this.prepareLibraryFiles(toImport);
        String libraryName = toImport.getInternalName();
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library != null) {
            LibraryDataService.syncPaths(toImport, library, modelsProvider);
            return;
        }
        library = modelsProvider.createLibrary(libraryName, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)toImport.getOwner()));
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        Set excludedPaths = toImport.getPaths(LibraryPathType.EXCLUDED);
        LibraryDataService.registerPaths(toImport.isUnresolved(), libraryFiles, excludedPaths, libraryModel, libraryName);
    }

    @NotNull
    public Map<OrderRootType, Collection<File>> prepareLibraryFiles(@NotNull LibraryData data2) {
        HashMap<OrderRootType, Collection<File>> result2 = new HashMap<OrderRootType, Collection<File>>();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            Set paths;
            OrderRootType orderRootType = ExternalLibraryPathTypeMapper.getInstance().map(pathType);
            if (orderRootType == null || (paths = data2.getPaths(pathType)).isEmpty()) continue;
            result2.put(orderRootType, ContainerUtil.map((Collection)paths, PATH_TO_FILE));
        }
        return result2;
    }

    static void registerPaths(boolean unresolved, @NotNull Map<OrderRootType, Collection<File>> libraryFiles, @NotNull Set<String> excludedPaths, @NotNull Library.ModifiableModel model, @NotNull String libraryName) {
        for (Map.Entry<OrderRootType, Collection<File>> entry : libraryFiles.entrySet()) {
            for (File file2 : entry.getValue()) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = virtualFile = unresolved ? null : ExternalSystemUtil.refreshAndFindFileByIoFile(file2);
                if (virtualFile == null) {
                    String[] urls;
                    String url;
                    if (!unresolved && ExternalSystemConstants.VERBOSE_PROCESSING && entry.getKey() == OrderRootType.CLASSES) {
                        LOG.warn(String.format("Can't find %s of the library '%s' at path '%s'", entry.getKey(), libraryName, file2.getAbsolutePath()));
                    }
                    if (ArrayUtil.contains((String)(url = VfsUtil.getUrlForLibraryRoot((File)file2)), (String[])(urls = model.getUrls(entry.getKey())))) continue;
                    model.addRoot(url, entry.getKey());
                    continue;
                }
                if (virtualFile.isDirectory()) {
                    Object[] files2 = model.getFiles(entry.getKey());
                    if (ArrayUtil.contains((Object)virtualFile, (Object[])files2)) continue;
                    model.addRoot(virtualFile, entry.getKey());
                    continue;
                }
                VirtualFile root = virtualFile;
                if (virtualFile.getFileType() instanceof ArchiveFileType && (root = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile)) == null) {
                    LOG.warn(String.format("Can't parse contents of the JAR file at path '%s' for the library '%s''", file2.getAbsolutePath(), libraryName));
                    continue;
                }
                Object[] files3 = model.getFiles(entry.getKey());
                if (ArrayUtil.contains((Object)root, (Object[])files3)) continue;
                model.addRoot(root, entry.getKey());
            }
        }
        if (model instanceof LibraryEx.ModifiableModelEx) {
            LibraryEx.ModifiableModelEx modelEx = (LibraryEx.ModifiableModelEx)model;
            for (String excludedPath : excludedPaths) {
                String[] urls;
                String url = VfsUtil.getUrlForLibraryRoot((File)new File(excludedPath));
                if (ArrayUtil.contains((String)url, (String[])(urls = modelEx.getExcludedRootUrls()))) continue;
                modelEx.addExcludedRoot(url);
            }
        }
    }

    public void postProcess(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (projectData2 == null) {
            return;
        }
        if (modelsProvider instanceof ProjectStructureUIModifiableModelsProvider) {
            return;
        }
        SmartList orphanIdeLibraries = new SmartList();
        LibraryTable.ModifiableModel librariesModel = modelsProvider.getModifiableProjectLibrariesModel();
        final HashMap<String, Library> namesToLibs = new HashMap<String, Library>();
        final HashSet<Library> potentialOrphans = new HashSet<Library>();
        RootPolicy<Void> excludeUsedLibraries = new RootPolicy<Void>(){

            public Void visitLibraryOrderEntry(@NotNull LibraryOrderEntry ideDependency, Void value2) {
                if (ideDependency.isModuleLevel()) {
                    return null;
                }
                Library lib = ideDependency.getLibrary();
                if (lib == null) {
                    lib = (Library)namesToLibs.get(ideDependency.getLibraryName());
                }
                if (lib != null) {
                    potentialOrphans.remove(lib);
                }
                return null;
            }
        };
        for (Library library : librariesModel.getLibraries()) {
            if (!ExternalSystemApiUtil.isExternalSystemLibrary((Library)library, (ProjectSystemId)projectData2.getOwner())) continue;
            namesToLibs.put(library.getName(), library);
            potentialOrphans.add(library);
        }
        for (Library library : modelsProvider.getModules()) {
            for (OrderEntry entry : modelsProvider.getOrderEntries((Module)library)) {
                entry.accept((RootPolicy)excludeUsedLibraries, null);
            }
        }
        for (Library lib : potentialOrphans) {
            if (modelsProvider.isSubstituted(lib.getName())) continue;
            orphanIdeLibraries.add(lib);
        }
        for (Library library : orphanIdeLibraries) {
            Library library2;
            String libraryName = library.getName();
            if (libraryName == null || (library2 = librariesModel.getLibraryByName(libraryName)) == null) continue;
            librariesModel.removeLibrary(library2);
        }
    }

    private static void syncPaths(@NotNull LibraryData externalLibrary, @NotNull Library ideLibrary, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (externalLibrary.isUnresolved()) {
            return;
        }
        HashMap toRemove2 = new HashMap();
        HashMap toAdd = new HashMap();
        ExternalLibraryPathTypeMapper externalLibraryPathTypeMapper = ExternalLibraryPathTypeMapper.getInstance();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            OrderRootType ideType = externalLibraryPathTypeMapper.map(pathType);
            if (ideType == null) continue;
            HashSet toAddPerType = new HashSet(externalLibrary.getPaths(pathType));
            toAdd.put(ideType, toAddPerType);
            if (pathType != LibraryPathType.BINARY && toAddPerType.isEmpty()) continue;
            HashSet<String> toRemovePerType = new HashSet<String>();
            toRemove2.put(ideType, toRemovePerType);
            for (VirtualFile ideFile : ideLibrary.getFiles(ideType)) {
                String idePath = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)ideFile);
                if (toAddPerType.remove(idePath)) continue;
                toRemovePerType.add(ideFile.getUrl());
            }
        }
        if (toRemove2.isEmpty() && toAdd.isEmpty()) {
            return;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(ideLibrary);
        for (Map.Entry entry : toRemove2.entrySet()) {
            for (String path : (Set)entry.getValue()) {
                libraryModel.removeRoot(path, (OrderRootType)entry.getKey());
            }
        }
        Set excludedPaths = externalLibrary.getPaths(LibraryPathType.EXCLUDED);
        for (Map.Entry entry : toAdd.entrySet()) {
            HashMap<OrderRootType, Collection<File>> roots = new HashMap<OrderRootType, Collection<File>>();
            roots.put((OrderRootType)entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), PATH_TO_FILE));
            LibraryDataService.registerPaths(externalLibrary.isUnresolved(), roots, excludedPaths, libraryModel, externalLibrary.getInternalName());
        }
    }
}

