/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.DisposableWrapperList;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemShortcutsManager
implements Disposable {
    private static final String ACTION_ID_PREFIX = "ExternalSystem_";
    @NotNull
    private final Project myProject;
    private final DisposableWrapperList<Listener> myListeners = new DisposableWrapperList();

    public ExternalSystemShortcutsManager(@NotNull Project project) {
        this.myProject = project;
    }

    public void init() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){

            public void activeKeymapChanged(Keymap keymap2) {
                ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
            }

            public void shortcutChanged(@NotNull Keymap keymap2, @NotNull String actionId) {
                ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
            }
        });
    }

    @NotNull
    public String getActionId(@Nullable String projectPath, @Nullable String taskName) {
        StringBuilder result2 = new StringBuilder(ACTION_ID_PREFIX);
        result2.append(this.myProject.getLocationHash());
        if (projectPath != null) {
            String portablePath = FileUtil.toSystemIndependentName((String)projectPath);
            File file2 = new File(portablePath);
            result2.append(file2.getParentFile() != null ? file2.getParentFile().getName() : file2.getName());
            result2.append(Integer.toHexString(portablePath.hashCode()));
            if (taskName != null) {
                result2.append(taskName);
            }
        }
        return result2.toString();
    }

    public String getDescription(@Nullable String projectPath, @Nullable String taskName) {
        Shortcut[] shortcuts = this.getShortcuts(projectPath, taskName);
        if (shortcuts.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    public boolean hasShortcuts(@Nullable String projectPath, @Nullable String taskName) {
        return this.getShortcuts(projectPath, taskName).length > 0;
    }

    public boolean hasShortcuts(@NotNull String actionId) {
        return KeymapUtil.getPrimaryShortcut((String)actionId) != null;
    }

    private Shortcut @NotNull [] getShortcuts(@Nullable String projectPath, @Nullable String taskName) {
        String actionId = this.getActionId(projectPath, taskName);
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        return activeKeymap.getShortcuts(actionId);
    }

    private void fireShortcutsUpdated() {
        for (Listener listener2 : this.myListeners) {
            listener2.shortcutsUpdated();
        }
    }

    public void addListener(Listener listener2, Disposable parent) {
        this.myListeners.add((Object)listener2, parent);
    }

    void scheduleKeymapUpdate(@NotNull Collection<? extends DataNode<TaskData>> taskData) {
        ExternalSystemKeymapExtension.updateActions(this.myProject, taskData);
    }

    void scheduleRunConfigurationKeymapUpdate(@NotNull ProjectSystemId externalSystemId) {
        ExternalSystemKeymapExtension.updateRunConfigurationActions(this.myProject, externalSystemId);
    }

    public void dispose() {
        ExternalSystemKeymapExtension.clearActions(this);
    }

    @FunctionalInterface
    public static interface Listener {
        public void shortcutsUpdated();
    }
}

