/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.autoimport.ProjectAware;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class ExternalProjectsSettingsWatcher
implements ExternalSystemSettingsListenerEx {
    ExternalProjectsSettingsWatcher() {
    }

    public void onProjectsLoaded(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings) {
        if (!(manager instanceof ExternalSystemAutoImportAware)) {
            return;
        }
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)project);
        ProjectSystemId systemId = manager.getSystemId();
        for (ExternalProjectSettings externalProjectSettings : settings) {
            String externalProjectPath = externalProjectSettings.getExternalProjectPath();
            projectTracker.activate(new ExternalSystemProjectId(systemId, externalProjectPath));
        }
    }

    public void onProjectsLinked(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings) {
        if (!(manager instanceof ExternalSystemAutoImportAware)) {
            return;
        }
        Disposable extensionDisposable = ExtensionPointUtil.createExtensionDisposable(manager, (ExtensionPointName)ExternalSystemManager.EP_NAME);
        Disposer.register((Disposable)project, (Disposable)extensionDisposable);
        ExternalSystemAutoImportAware autoImportAware = (ExternalSystemAutoImportAware)manager;
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)project);
        ProjectSystemId systemId = manager.getSystemId();
        for (ExternalProjectSettings externalProjectSettings : settings) {
            String externalProjectPath = externalProjectSettings.getExternalProjectPath();
            ExternalSystemProjectId id2 = new ExternalSystemProjectId(systemId, externalProjectPath);
            projectTracker.register((ExternalSystemProjectAware)new ProjectAware(project, id2, autoImportAware), extensionDisposable);
        }
    }

    public void onProjectsUnlinked(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Set<String> linkedProjectPaths) {
        if (!(manager instanceof ExternalSystemAutoImportAware)) {
            return;
        }
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)project);
        ProjectSystemId systemId = manager.getSystemId();
        for (String linkedProjectPath : linkedProjectPaths) {
            projectTracker.remove(new ExternalSystemProjectId(systemId, linkedProjectPath));
        }
    }
}

