/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModifiableModelsProviderImpl
extends AbstractIdeModifiableModelsProvider {
    private final LibraryTable.ModifiableModel myLibrariesModel;

    public IdeModifiableModelsProviderImpl(Project project) {
        super(project);
        this.myLibrariesModel = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getModifiableModel();
    }

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableProjectLibrariesModel() {
        return this.myLibrariesModel;
    }

    @Override
    protected ModifiableModuleModel doGetModifiableModuleModel() {
        return (ModifiableModuleModel)ReadAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).getModifiableModel());
    }

    @Override
    @NotNull
    protected ModifiableRootModel doGetModifiableRootModel(@NotNull Module module) {
        return (ModifiableRootModel)ReadAction.compute(() -> ModuleRootManagerEx.getInstanceEx(module).getModifiableModelForMultiCommit(new RootConfigurationAccessor(){

            @Override
            @Nullable
            public Library getLibrary(Library library, String libraryName, String libraryLevel) {
                if ("project".equals(libraryLevel)) {
                    return IdeModifiableModelsProviderImpl.this.myLibrariesModel.getLibraryByName(libraryName);
                }
                return library;
            }
        }));
    }

    @Override
    protected ModifiableFacetModel doGetModifiableFacetModel(Module module) {
        return FacetManager.getInstance((Module)module).createModifiableModel();
    }

    @Override
    protected Library.ModifiableModel doGetModifiableLibraryModel(Library library) {
        return library.getModifiableModel();
    }
}

