/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecImpl;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemResolveProjectTask
extends AbstractExternalSystemTask {
    private final AtomicReference<DataNode<ProjectData>> myExternalProject = new AtomicReference();
    @NotNull
    private final String myProjectPath;
    private final boolean myIsPreviewMode;
    @Nullable
    private final String myVmOptions;
    @Nullable
    private final String myArguments;
    @Nullable
    private final ProjectResolverPolicy myResolverPolicy;

    public ExternalSystemResolveProjectTask(@NotNull Project project, @NotNull String projectPath, @NotNull ImportSpec importSpec) {
        super(importSpec.getExternalSystemId(), ExternalSystemTaskType.RESOLVE_PROJECT, project, projectPath);
        this.myProjectPath = projectPath;
        this.myIsPreviewMode = importSpec.isPreviewMode();
        this.myVmOptions = importSpec.getVmOptions();
        this.myArguments = importSpec.getArguments();
        this.myResolverPolicy = importSpec instanceof ImportSpecImpl ? ((ImportSpecImpl)importSpec).getProjectResolverPolicy() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        ExternalSystemExecutionSettings settings;
        RemoteExternalSystemProjectResolver<ExternalSystemExecutionSettings> resolver;
        Project ideProject;
        ExternalSystemProgressNotificationManagerImpl progressNotificationManager = (ExternalSystemProgressNotificationManagerImpl)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        ExternalSystemTaskId id2 = this.getId();
        try {
            progressNotificationManager.onStart(id2, this.myProjectPath);
            ideProject = this.getIdeProject();
            ExternalSystemTaskNotificationListener progressNotificationListener = ExternalSystemResolveProjectTask.wrapWithListener(progressNotificationManager);
            for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.getExtensions(this.getExternalSystemId())) {
                executionAware.prepareExecution(this, this.myProjectPath, this.myIsPreviewMode, progressNotificationListener, ideProject);
            }
            ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
            resolver = manager.getFacade(ideProject, this.myProjectPath, this.getExternalSystemId()).getResolver();
            settings = ExternalSystemApiUtil.getExecutionSettings((Project)ideProject, (String)this.myProjectPath, (ProjectSystemId)this.getExternalSystemId());
            if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
                settings.withVmOptions((Collection)ParametersListUtil.parse((String)this.myVmOptions));
            }
            if (StringUtil.isNotEmpty((String)this.myArguments)) {
                settings.withArguments((Collection)ParametersListUtil.parse((String)this.myArguments));
            }
        }
        catch (Exception e) {
            progressNotificationManager.onFailure(id2, e);
            progressNotificationManager.onEnd(id2);
            throw e;
        }
        try {
            DataNode<ProjectData> project = resolver.resolveProjectInfo(id2, this.myProjectPath, this.myIsPreviewMode, settings, this.myResolverPolicy);
            if (project != null) {
                this.myExternalProject.set(project);
                ExternalSystemManager systemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.getExternalSystemId());
                assert (systemManager != null);
                HashSet<String> externalModulePaths = new HashSet<String>();
                Collection moduleNodes = ExternalSystemApiUtil.findAll(project, (Key)ProjectKeys.MODULE);
                for (DataNode node : moduleNodes) {
                    externalModulePaths.add(((ModuleData)node.getData()).getLinkedExternalProjectPath());
                }
                String projectPath = ((ProjectData)project.getData()).getLinkedExternalProjectPath();
                ExternalProjectSettings linkedProjectSettings = ((AbstractExternalSystemSettings)systemManager.getSettingsProvider().fun((Object)ideProject)).getLinkedProjectSettings(projectPath);
                if (linkedProjectSettings != null && !externalModulePaths.isEmpty()) {
                    linkedProjectSettings.setModules(externalModulePaths);
                }
            }
            progressNotificationManager.onSuccess(id2);
        }
        finally {
            progressNotificationManager.onEnd(id2);
        }
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        Project ideProject = this.getIdeProject();
        RemoteExternalSystemProjectResolver resolver = manager.getFacade(ideProject, this.myProjectPath, this.getExternalSystemId()).getResolver();
        return resolver.cancelTask(this.getId());
    }

    @Override
    @NotNull
    protected String wrapProgressText(@NotNull String text) {
        return ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId().getReadableName(), text});
    }

    @Nullable
    public ProjectResolverPolicy getResolverPolicy() {
        return this.myResolverPolicy;
    }

    @Override
    protected void setState(@NotNull ExternalSystemTaskState state) {
        super.setState(state);
        if (state.isStopped() && (this.myResolverPolicy == null || !this.myResolverPolicy.isPartialDataResolveAllowed())) {
            InternalExternalProjectInfo projectInfo = new InternalExternalProjectInfo(this.getExternalSystemId(), this.getExternalProjectPath(), (DataNode<ProjectData>)((DataNode)this.myExternalProject.getAndSet(null)));
            long currentTimeMillis = System.currentTimeMillis();
            projectInfo.setLastImportTimestamp(currentTimeMillis);
            projectInfo.setLastSuccessfulImportTimestamp(state == ExternalSystemTaskState.FAILED ? -1L : currentTimeMillis);
            ProjectDataManagerImpl.getInstance().updateExternalProjectData(this.getIdeProject(), projectInfo);
        }
    }
}

