/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.build.events.ProgressBuildEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.execution.NotSupportedException;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemTask
extends UserDataHolderBase
implements ExternalSystemTask {
    private static final Logger LOG = Logger.getInstance(AbstractExternalSystemTask.class);
    private final AtomicReference<ExternalSystemTaskState> myState = new AtomicReference<ExternalSystemTaskState>(ExternalSystemTaskState.NOT_STARTED);
    private final AtomicReference<Throwable> myError = new AtomicReference();
    @NotNull
    private final transient Project myIdeProject;
    @NotNull
    private final ExternalSystemTaskId myId;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final String myExternalProjectPath;

    protected AbstractExternalSystemTask(@NotNull ProjectSystemId id2, @NotNull ExternalSystemTaskType type, @NotNull Project project, @NotNull String externalProjectPath) {
        this.myExternalSystemId = id2;
        this.myIdeProject = project;
        this.myId = ExternalSystemTaskId.create((ProjectSystemId)id2, (ExternalSystemTaskType)type, (Project)this.myIdeProject);
        this.myExternalProjectPath = externalProjectPath;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return this.myExternalSystemId;
    }

    @NotNull
    public ExternalSystemTaskId getId() {
        return this.myId;
    }

    @NotNull
    public ExternalSystemTaskState getState() {
        return this.myState.get();
    }

    protected void setState(@NotNull ExternalSystemTaskState state) {
        this.myState.set(state);
    }

    protected boolean compareAndSetState(@NotNull ExternalSystemTaskState expect, @NotNull ExternalSystemTaskState update2) {
        return this.myState.compareAndSet(expect, update2);
    }

    public Throwable getError() {
        return this.myError.get();
    }

    @NotNull
    public Project getIdeProject() {
        return this.myIdeProject;
    }

    @NotNull
    public String getExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    public void refreshState() {
        block3: {
            if (this.getState() != ExternalSystemTaskState.IN_PROGRESS) {
                return;
            }
            ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
            try {
                RemoteExternalSystemFacade facade = manager.getFacade(this.myIdeProject, this.myExternalProjectPath, this.myExternalSystemId);
                this.setState(facade.isTaskInProgress(this.getId()) ? ExternalSystemTaskState.IN_PROGRESS : ExternalSystemTaskState.FAILED);
            }
            catch (Throwable e) {
                this.setState(ExternalSystemTaskState.FAILED);
                this.myError.set(e);
                if (this.myIdeProject.isDisposed()) break block3;
                LOG.warn(e);
            }
        }
    }

    public void execute(final @NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter adapter2 = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                AbstractExternalSystemTask.this.updateProgressIndicator(event, indicator);
            }
        };
        ExternalSystemTaskNotificationListener[] ls = listeners.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)adapter2) : new ExternalSystemTaskNotificationListener[]{adapter2};
        this.execute(ls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExternalSystemTaskNotificationListener ... listeners) {
        if (!this.compareAndSetState(ExternalSystemTaskState.NOT_STARTED, ExternalSystemTaskState.IN_PROGRESS)) {
            return;
        }
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener listener2 : listeners) {
            progressManager.addNotificationListener(this.getId(), listener2);
        }
        ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        try {
            processingManager.add(this);
            this.doExecute();
            this.setState(ExternalSystemTaskState.FINISHED);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            this.myError.set(e);
            this.setState(ExternalSystemTaskState.FAILED);
        }
        catch (Throwable e) {
            LOG.error(e);
            this.myError.set(e);
            this.setState(ExternalSystemTaskState.FAILED);
        }
        finally {
            processingManager.release(this.getId());
        }
    }

    protected abstract void doExecute() throws Exception;

    public boolean cancel(final @NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter adapter2 = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                indicator.setText(AbstractExternalSystemTask.this.wrapProgressText(event.getDescription()));
            }
        };
        ExternalSystemTaskNotificationListener[] ls = listeners.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)adapter2) : new ExternalSystemTaskNotificationListener[]{adapter2};
        return this.cancel(ls);
    }

    public boolean cancel(ExternalSystemTaskNotificationListener ... listeners) {
        ExternalSystemTaskState currentTaskState = this.getState();
        if (currentTaskState.isStopped()) {
            return true;
        }
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener listener2 : listeners) {
            progressManager.addNotificationListener(this.getId(), listener2);
        }
        if (!this.compareAndSetState(currentTaskState, ExternalSystemTaskState.CANCELING)) {
            return false;
        }
        try {
            return this.doCancel();
        }
        catch (NotSupportedException e) {
            NotificationData notification = new NotificationData("Cancellation failed", e.getMessage(), NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            notification.setBalloonNotification(true);
            ExternalSystemNotificationManager.getInstance(this.getIdeProject()).showNotification(this.getExternalSystemId(), notification);
        }
        catch (Throwable e) {
            this.setState(ExternalSystemTaskState.CANCELLATION_FAILED);
            this.myError.set(e);
            LOG.warn(e);
        }
        return false;
    }

    protected abstract boolean doCancel() throws Exception;

    @NotNull
    protected String wrapProgressText(@NotNull String text) {
        return ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId(), text});
    }

    public int hashCode() {
        return this.myId.hashCode() + this.myExternalSystemId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractExternalSystemTask task2 = (AbstractExternalSystemTask)((Object)o);
        return this.myId.equals((Object)task2.myId) && this.myExternalSystemId.equals((Object)task2.myExternalSystemId);
    }

    public String toString() {
        return String.format("%s task %s: %s", this.myExternalSystemId.getReadableName(), this.myId, this.myState);
    }

    private void updateProgressIndicator(@NotNull ExternalSystemTaskNotificationEvent event, @NotNull ProgressIndicator indicator) {
        String sizeInfo;
        String unit;
        long progress2;
        long total;
        ProgressBuildEvent progressEvent;
        if (event instanceof ExternalSystemBuildEvent && ((ExternalSystemBuildEvent)event).getBuildEvent() instanceof ProgressBuildEvent) {
            progressEvent = (ProgressBuildEvent)((ExternalSystemBuildEvent)event).getBuildEvent();
            total = progressEvent.getTotal();
            progress2 = progressEvent.getProgress();
            unit = progressEvent.getUnit();
        } else if (event instanceof ExternalSystemTaskExecutionEvent && ((ExternalSystemTaskExecutionEvent)event).getProgressEvent() instanceof ExternalSystemStatusEvent) {
            progressEvent = (ExternalSystemStatusEvent)((ExternalSystemTaskExecutionEvent)event).getProgressEvent();
            total = progressEvent.getTotal();
            progress2 = progressEvent.getProgress();
            unit = progressEvent.getUnit();
        } else {
            return;
        }
        if (total <= 0L) {
            indicator.setIndeterminate(true);
            sizeInfo = "bytes".equals(unit) ? StringUtil.formatFileSize((long)progress2) + " / ?" : "";
        } else {
            indicator.setIndeterminate(false);
            indicator.setFraction((double)progress2 / (double)total);
            sizeInfo = "bytes".equals(unit) ? StringUtil.formatFileSize((long)progress2) + " / " + StringUtil.formatFileSize((long)total) : "";
        }
        String description = event.getDescription();
        indicator.setText(this.wrapProgressText(description) + (sizeInfo.isEmpty() ? "" : "  (" + sizeInfo + ')'));
    }

    @NotNull
    protected static ExternalSystemTaskNotificationListener wrapWithListener(final @NotNull ExternalSystemProgressNotificationManagerImpl manager) {
        return new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                manager.onStatusChange(event);
            }

            public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text, boolean stdOut) {
                manager.onTaskOutput(id2, text, stdOut);
            }
        };
    }
}

