/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StorageCreator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalModuleStorage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalProjectFilteringStorage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalProjectStorage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalStorageSpec
extends FileStorageAnnotation
implements StorageCreator {
    private final State inProjectStateSpec;

    public ExternalStorageSpec(@NotNull String path, @Nullable State inProjectStateSpec) {
        super(path, false);
        this.inProjectStateSpec = inProjectStateSpec;
    }

    @Override
    @NotNull
    public StateStorage create(@NotNull StateStorageManager storageManager) {
        ComponentManager componentManager = storageManager.getComponentManager();
        assert (componentManager != null);
        if (this.path.equals("$MODULE_FILE$")) {
            return new ExternalModuleStorage((Module)componentManager, storageManager);
        }
        Project project = (Project)componentManager;
        if (this.inProjectStateSpec == null) {
            return new ExternalProjectStorage(this.path, project, storageManager);
        }
        return new ExternalProjectFilteringStorage(this.path, project, storageManager, this.inProjectStateSpec.name(), (DirectoryBasedStorage)storageManager.getStateStorage(this.inProjectStateSpec.storages()[0]));
    }

    @Override
    @NotNull
    public String getKey() {
        return "external://" + this.path;
    }
}

