/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemTreeAction
extends ExternalSystemAction {
    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return super.isEnabled(e) && ExternalSystemTreeAction.getTree(e) != null;
    }

    @Nullable
    protected static JTree getTree(@NotNull AnActionEvent e) {
        return (JTree)e.getData(ExternalSystemDataKeys.PROJECTS_TREE);
    }

    public static class ExpandAll
    extends ExternalSystemTreeAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            JTree tree = ExpandAll.getTree(e);
            if (tree == null) {
                return;
            }
            TreeUtil.expandAll((JTree)tree);
        }
    }

    public static class CollapseAll
    extends ExternalSystemTreeAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            JTree tree = CollapseAll.getTree(e);
            if (tree == null) {
                return;
            }
            TreeUtil.collapseAll((JTree)tree, (int)-1);
        }
    }
}

