/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

class TextComponentDocument
extends UserDataHolderBase
implements Document {
    private final JTextComponent myTextComponent;

    TextComponentDocument(JTextComponent textComponent) {
        this.myTextComponent = textComponent;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        try {
            javax.swing.text.Document document = this.myTextComponent.getDocument();
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public String getText(@NotNull TextRange range2) {
        try {
            javax.swing.text.Document document = this.myTextComponent.getDocument();
            return document.getText(range2.getStartOffset(), range2.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public int getTextLength() {
        return this.myTextComponent.getDocument().getLength();
    }

    public int getLineCount() {
        return 1;
    }

    public int getLineNumber(int offset) {
        return 0;
    }

    public int getLineStartOffset(int line) {
        return 0;
    }

    public int getLineEndOffset(int line) {
        return this.getTextLength();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        try {
            this.myTextComponent.getDocument().insertString(offset, s.toString(), null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        try {
            this.myTextComponent.getDocument().remove(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        javax.swing.text.Document document = this.myTextComponent.getDocument();
        try {
            document.remove(startOffset, endOffset - startOffset);
            document.insertString(startOffset, s.toString(), null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isWritable() {
        return true;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setText(@NotNull CharSequence text) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

