/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentCaret;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.editor.textarea.TextComponentEditorImpl;
import com.intellij.util.EventDispatcher;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextComponentCaretModel
implements CaretModel {
    private final TextComponentEditor myEditor;
    private final Caret myCaret;
    private final EventDispatcher<CaretActionListener> myCaretActionListeners = EventDispatcher.create(CaretActionListener.class);

    TextComponentCaretModel(@NotNull TextComponentEditorImpl editor) {
        this.myEditor = editor;
        this.myCaret = new TextComponentCaret(editor);
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        if (!(lineShift != 0 || withSelection || blockSelection || scrollToCaret)) {
            this.moveToOffset(this.getOffset() + columnShift);
            return;
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public TextAttributes getTextAttributes() {
        return null;
    }

    public boolean supportsMultipleCarets() {
        return false;
    }

    @NotNull
    public Caret getCurrentCaret() {
        return this.myCaret;
    }

    @NotNull
    public Caret getPrimaryCaret() {
        return this.myCaret;
    }

    public int getCaretCount() {
        return 1;
    }

    @NotNull
    public List<Caret> getAllCarets() {
        return Collections.singletonList(this.myCaret);
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        return this.myCaret.getVisualPosition().equals((Object)pos) ? this.myCaret : null;
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        return null;
    }

    @Nullable
    public Caret addCaret(@NotNull LogicalPosition pos, boolean makePrimary) {
        return null;
    }

    public boolean removeCaret(@NotNull Caret caret) {
        return false;
    }

    public void removeSecondaryCarets() {
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates) {
        if (caretStates.size() != 1) {
            throw new IllegalArgumentException("Exactly one CaretState object must be passed");
        }
        CaretState state = caretStates.get(0);
        if (state != null) {
            if (state.getCaretPosition() != null) {
                this.moveToLogicalPosition(state.getCaretPosition());
            }
            if (state.getSelectionStart() != null && state.getSelectionEnd() != null) {
                this.myEditor.getSelectionModel().setSelection(this.myEditor.logicalPositionToOffset(state.getSelectionStart()), this.myEditor.logicalPositionToOffset(state.getSelectionEnd()));
            }
        }
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates, boolean updateSystemSelection) {
        this.setCaretsAndSelections(caretStates);
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        return Collections.singletonList(new CaretState(this.getLogicalPosition(), this.myEditor.offsetToLogicalPosition(this.myEditor.getSelectionModel().getSelectionStart()), this.myEditor.offsetToLogicalPosition(this.myEditor.getSelectionModel().getSelectionEnd())));
    }

    public void runForEachCaret(@NotNull CaretAction action2) {
        ((CaretActionListener)this.myCaretActionListeners.getMulticaster()).beforeAllCaretsAction();
        action2.perform(this.myCaret);
        ((CaretActionListener)this.myCaretActionListeners.getMulticaster()).afterAllCaretsAction();
    }

    public void runForEachCaret(@NotNull CaretAction action2, boolean reverseOrder) {
        this.runForEachCaret(action2);
    }

    public void addCaretActionListener(@NotNull CaretActionListener listener2, @NotNull Disposable disposable2) {
        this.myCaretActionListeners.addListener((EventListener)listener2, disposable2);
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        runnable2.run();
    }
}

