/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.RawTextWithMarkup;
import com.intellij.openapi.util.registry.Registry;
import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractSyntaxAwareInputStreamTransferableData
extends InputStream
implements RawTextWithMarkup {
    private static final Logger LOG = Logger.getInstance(AbstractSyntaxAwareInputStreamTransferableData.class);
    String myRawText;
    @NotNull
    final SyntaxInfo mySyntaxInfo;
    @NotNull
    private final DataFlavor myDataFlavor;
    @Nullable
    private transient InputStream myDelegate;

    AbstractSyntaxAwareInputStreamTransferableData(@NotNull SyntaxInfo syntaxInfo, @NotNull DataFlavor flavor) {
        this.mySyntaxInfo = syntaxInfo;
        this.myDataFlavor = flavor;
    }

    @Override
    public DataFlavor getFlavor() {
        return this.myDataFlavor;
    }

    @Override
    public int getOffsetCount() {
        return 0;
    }

    @Override
    public int getOffsets(int[] offsets2, int index) {
        return index;
    }

    @Override
    public int setOffsets(int[] offsets2, int index) {
        return index;
    }

    @Override
    public int read() throws IOException {
        return this.getDelegate().read();
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        return this.getDelegate().read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.myDelegate = null;
    }

    @Override
    public void setRawText(String rawText) {
        this.myRawText = rawText;
    }

    @NotNull
    private InputStream getDelegate() {
        if (this.myDelegate != null) {
            return this.myDelegate;
        }
        int maxLength = Registry.intValue((String)"editor.richcopy.max.size.megabytes") * 0x100000;
        StringBuilder buffer = new StringBuilder();
        try {
            this.build(buffer, maxLength);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        String s = buffer.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting text: \n" + s);
        }
        try {
            this.myDelegate = new ByteArrayInputStream(s.getBytes(this.getCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.myDelegate;
    }

    protected abstract void build(@NotNull StringBuilder var1, int var2);

    @NotNull
    protected abstract String getCharset();

    @Override
    public synchronized void mark(int readlimit) {
        this.getDelegate().mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getDelegate().reset();
    }

    @Override
    public boolean markSupported() {
        return this.getDelegate().markSupported();
    }
}

