/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.Getter;
import com.intellij.util.DocumentEventUtil;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T>
implements PrioritizedDocumentListener {
    private static final int DUPLICATE_LIMIT = 30;

    RangeMarkerTree(@NotNull Document document) {
        document.addDocumentListener((DocumentListener)this);
    }

    RangeMarkerTree() {
    }

    @Override
    public int getPriority() {
        return 40;
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean stickyR2;
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d != 0) {
            return d;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        boolean stickyR1 = o1.isStickingToRight();
        if (stickyR1 != (stickyR2 = o2.isStickingToRight())) {
            return stickyR1 ? -1 : 1;
        }
        return 0;
    }

    void dispose(@NotNull Document document) {
        document.removeDocumentListener((DocumentListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RMNode<T> addInterval(@NotNull T interval, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        ((RangeMarkerImpl)interval).setValid(true);
        RMNode node = (RMNode)super.addInterval(interval, start2, end, greedyToLeft, greedyToRight, stickingToRight, layer);
        if (DEBUG && node.intervals.size() > 30 && !ApplicationInfoImpl.isInStressTest() && ApplicationManager.getApplication().isUnitTestMode()) {
            this.l.readLock().lock();
            try {
                String msg = this.errMsg(node);
                if (msg != null) {
                    LOG.warn(msg);
                }
            }
            finally {
                this.l.readLock().unlock();
            }
        }
        return node;
    }

    private String errMsg(@NotNull RMNode<T> node) {
        System.gc();
        AtomicInteger alive = new AtomicInteger();
        node.processAliveKeys(t -> {
            alive.incrementAndGet();
            return true;
        });
        if (alive.get() > 30) {
            return "Too many range markers (" + alive + ") registered for interval " + node;
        }
        return null;
    }

    @Override
    @NotNull
    protected RMNode<T> createNewNode(@NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        return new RMNode<T>(this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight);
    }

    @Override
    protected RMNode<T> lookupNode(@NotNull T key) {
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        try {
            this.l.writeLock().lock();
            if (this.size() != 0) {
                this.updateMarkersOnChange(e);
                if (DocumentEventUtil.isMoveInsertion(e)) {
                    this.reTargetMarkersOnChange(e);
                }
                IntervalTreeImpl.IntervalNode root = this.getRoot();
                assert (root == null || root.maxEnd + root.delta <= e.getDocument().getTextLength()) : "Root: " + root + "; root.maxEnd=" + root.maxEnd + "; root.delta=" + root.delta + "; e.getDocument().getTextLength()=" + e.getDocument().getTextLength() + "; event: " + e;
            }
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void updateMarkersOnChange(@NotNull DocumentEvent e) {
        this.checkMax(true);
        this.incModCount();
        SmartList affected = new SmartList();
        int start2 = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), start2, start2 + oldLength, newLength - oldLength, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
        this.checkMax(false);
        if (!affected.isEmpty()) {
            this.updateAffectedNodes(e, 0, (List<IntervalTreeImpl.IntervalNode<T>>)affected);
        }
    }

    private void updateAffectedNodes(@NotNull DocumentEvent e, int reTargetShift, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected) {
        for (int i2 = affected.size() - 1; i2 >= 0; --i2) {
            IntervalTreeImpl.IntervalNode<T> node = affected.get(i2);
            int startOffset = node.intervalStart();
            int endOffset = node.intervalEnd();
            this.removeNode(node);
            this.checkMax(false);
            node.setParent(null);
            node.setLeft(null);
            node.setRight(null);
            node.setValid(true);
            if (reTargetShift == 0) {
                node.clearDelta();
                assert (node.intervalStart() == startOffset);
                assert (node.intervalEnd() == endOffset);
                continue;
            }
            node.changeDelta(reTargetShift);
            this.pushDelta(node);
        }
        this.checkMax(true);
        for (IntervalTreeImpl.IntervalNode<T> node : affected) {
            RangeMarkerImpl marker = RangeMarkerTree.getNodeMarker(node);
            if (marker == null) continue;
            if (reTargetShift == 0) {
                marker.documentChanged(e);
            } else {
                marker.onReTarget(e);
            }
            if (marker.isValid()) {
                this.findOrInsertWithIntervals(node);
                continue;
            }
            node.setValid(false);
            ((RMNode)node).onRemoved();
        }
        this.checkMax(true);
    }

    @Nullable
    private static <T extends RangeMarkerEx> RangeMarkerImpl getNodeMarker(@NotNull IntervalTreeImpl.IntervalNode<T> node) {
        List keys2 = node.intervals;
        for (int i2 = keys2.size() - 1; i2 >= 0; --i2) {
            Getter key = keys2.get(i2);
            RangeMarkerImpl marker = (RangeMarkerImpl)key.get();
            if (marker == null) continue;
            if (marker.isValid()) {
                return marker;
            }
            node.removeIntervalInternal(i2);
        }
        return null;
    }

    private void findOrInsertWithIntervals(IntervalTreeImpl.IntervalNode<T> node) {
        IntervalTreeImpl.IntervalNode<T> insertedNode = this.findOrInsert(node);
        if (insertedNode != node) {
            insertedNode.addIntervalsFrom(node);
        }
    }

    boolean collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<T> root, int start2, int end, int lengthDelta, @NotNull List<? super IntervalTreeImpl.IntervalNode<T>> affected) {
        if (root == null) {
            return true;
        }
        boolean norm = this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        boolean hasAliveKeys = root.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root);
        }
        if (start2 <= maxEnd) {
            if (end < root.intervalStart()) {
                int newD = root.changeDelta(lengthDelta);
                norm &= newD == 0;
                RedBlackTree.Node left = root.getLeft();
                if (left != null) {
                    int newL = ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                    norm &= newL == 0;
                }
                norm &= this.pushDelta(root);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, start2, end, lengthDelta, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.correctMax(root, 0);
            } else {
                if (start2 <= root.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root);
                    }
                    root.setValid(false);
                }
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), start2, end, lengthDelta, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getRight(), start2, end, lengthDelta, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.correctMax(root, 0);
            }
        }
        return norm;
    }

    private void reTargetMarkersOnChange(@NotNull DocumentEvent e) {
        this.checkMax(true);
        SmartList affected = new SmartList();
        int moveStart = e.getMoveOffset();
        int moveEnd = moveStart + e.getNewLength();
        this.collectNodesToRetarget(this.getRoot(), moveStart, moveEnd, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
        if (!affected.isEmpty()) {
            this.updateAffectedNodes(e, e.getOffset() - e.getMoveOffset(), (List<IntervalTreeImpl.IntervalNode<T>>)affected);
        }
    }

    private void collectNodesToRetarget(@Nullable IntervalTreeImpl.IntervalNode<T> root, int start2, int end, @NotNull List<? super IntervalTreeImpl.IntervalNode<T>> affected) {
        if (root == null) {
            return;
        }
        this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        if (start2 > maxEnd) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), start2, end, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
        if (start2 <= root.intervalStart() && root.intervalEnd() <= end) {
            affected.add(root);
        }
        if (end < root.intervalStart()) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getRight(), start2, end, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
    }

    static class RMNode<T extends RangeMarkerEx>
    extends IntervalTreeImpl.IntervalNode<T> {
        private static final byte EXPAND_TO_LEFT_FLAG = 8;
        private static final byte EXPAND_TO_RIGHT_FLAG = 16;
        static final byte STICK_TO_RIGHT_FLAG = 32;

        RMNode(@NotNull RangeMarkerTree<T> rangeMarkerTree, @NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight) {
            super(rangeMarkerTree, key, start2, end);
            this.setFlag((byte)8, greedyToLeft);
            this.setFlag((byte)16, greedyToRight);
            this.setFlag((byte)32, stickingToRight);
        }

        boolean isGreedyToLeft() {
            return this.isFlagSet((byte)8);
        }

        boolean isGreedyToRight() {
            return this.isFlagSet((byte)16);
        }

        boolean isStickingToRight() {
            return this.isFlagSet((byte)32);
        }

        void onRemoved() {
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }
    }
}

