/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentEventUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualRangeMarker
implements Segment {
    private final int myStart;
    private final int myEnd;
    private final boolean myGreedyLeft;
    private final boolean myGreedyRight;
    private final boolean mySurviveOnExternalChange;
    private final PersistentRangeMarker.LinesCols myLinesCols;

    public ManualRangeMarker(int start2, int end, boolean greedyLeft, boolean greedyRight, boolean surviveOnExternalChange, @Nullable PersistentRangeMarker.LinesCols linesCols) {
        this.myStart = start2;
        this.myEnd = end;
        this.myGreedyLeft = greedyLeft;
        this.myGreedyRight = greedyRight;
        this.mySurviveOnExternalChange = surviveOnExternalChange;
        this.myLinesCols = linesCols;
    }

    @Nullable
    public ManualRangeMarker getUpdatedRange(@NotNull DocumentEvent event, @NotNull FrozenDocument documentBefore) {
        int srcOffset;
        TextRange range2;
        if (this.mySurviveOnExternalChange && PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, this.myStart, this.myEnd)) {
            Pair.NonNull<TextRange, PersistentRangeMarker.LinesCols> pair;
            PersistentRangeMarker.LinesCols linesCols = this.myLinesCols != null ? this.myLinesCols : PersistentRangeMarker.storeLinesAndCols(documentBefore, this.myStart, this.myEnd);
            Pair.NonNull<TextRange, PersistentRangeMarker.LinesCols> nonNull = pair = linesCols == null ? null : PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, linesCols);
            if (pair != null) {
                return new ManualRangeMarker(((TextRange)pair.first).getStartOffset(), ((TextRange)pair.first).getEndOffset(), this.myGreedyLeft, this.myGreedyRight, true, (PersistentRangeMarker.LinesCols)pair.second);
            }
        }
        if ((range2 = RangeMarkerImpl.applyChange(event, this.myStart, this.myEnd, this.myGreedyLeft, this.myGreedyRight, false)) == null) {
            return null;
        }
        int delta = 0;
        if (DocumentEventUtil.isMoveInsertion(event) && (srcOffset = event.getMoveOffset()) <= range2.getStartOffset() && range2.getEndOffset() <= srcOffset + event.getNewLength()) {
            delta = event.getOffset() - srcOffset;
        }
        return new ManualRangeMarker(range2.getStartOffset() + delta, range2.getEndOffset() + delta, this.myGreedyLeft, this.myGreedyRight, this.mySurviveOnExternalChange, null);
    }

    public int getStartOffset() {
        return this.myStart;
    }

    public int getEndOffset() {
        return this.myEnd;
    }

    public String toString() {
        return "ManualRangeMarker" + TextRange.create((Segment)this);
    }
}

