/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.editor.markup.LanguageHighlightLevel;
import com.intellij.openapi.editor.markup.PassWrapper;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;

class InspectionPopupManager {
    private static final int DELTA_X = 6;
    private static final int DELTA_Y = 6;
    private final Supplier<AnalyzerStatus> statusSupplier;
    private final Editor myEditor;
    private final AnAction compactViewAction;
    private final JPanel myContent = new JPanel(new GridBagLayout());
    private final ComponentPopupBuilder myPopupBuilder;
    private final Map<String, JProgressBar> myProgressBarMap = new HashMap<String, JProgressBar>();
    private final AncestorListener myAncestorListener;
    private final JBPopupListener myPopupListener;
    private final PopupState myPopupState = new PopupState();
    private final Alarm popupAlarm = new Alarm();
    private final List<DropDownLink<?>> levelLinks = new ArrayList();
    private JBPopup myPopup;
    private boolean insidePopup;

    InspectionPopupManager(final @NotNull Supplier<AnalyzerStatus> statusSupplier, @NotNull Editor editor, @NotNull AnAction compactViewAction) {
        this.statusSupplier = statusSupplier;
        this.myEditor = editor;
        this.compactViewAction = compactViewAction;
        this.myContent.setOpaque(true);
        this.myContent.setBackground(UIUtil.getToolTipBackground());
        this.myPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myContent, null).setCancelOnClickOutside(true).setCancelCallback(() -> this.getAnalyzerStatus() == null || this.getAnalyzerStatus().getController().canClosePopup());
        this.myAncestorListener = new AncestorListenerAdapter(){

            public void ancestorMoved(AncestorEvent event) {
                InspectionPopupManager.this.hidePopup();
            }
        };
        this.myPopupListener = new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (statusSupplier.get() != null) {
                    ((AnalyzerStatus)statusSupplier.get()).getController().onClosePopup();
                }
                InspectionPopupManager.this.myEditor.getComponent().removeAncestorListener(InspectionPopupManager.this.myAncestorListener);
            }
        };
        this.myContent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                InspectionPopupManager.this.insidePopup = true;
            }

            @Override
            public void mouseExited(MouseEvent event) {
                Point point = event.getPoint();
                if (!InspectionPopupManager.this.myContent.getBounds().contains(point) || point.x == 0 || point.y == 0) {
                    InspectionPopupManager.this.insidePopup = false;
                    if (InspectionPopupManager.this.canClose()) {
                        InspectionPopupManager.this.hidePopup();
                    }
                }
            }
        });
    }

    private boolean canClose() {
        return !this.insidePopup && this.levelLinks.stream().allMatch(l -> l.getPopupState().isHidden());
    }

    void updateUI() {
        IJSwingUtilities.updateComponentTreeUI(this.myContent);
    }

    void scheduleShow(@NotNull InputEvent event) {
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> this.showPopup(event), Registry.intValue((String)"ide.tooltip.initialReshowDelay"));
    }

    void scheduleHide() {
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> {
            if (this.canClose()) {
                this.hidePopup();
            }
        }, Registry.intValue((String)"ide.tooltip.initialDelay.highlighter"));
    }

    void showPopup(@NotNull InputEvent event) {
        this.hidePopup();
        if (this.myPopupState.isRecentlyHidden()) {
            return;
        }
        this.updateContentPanel(this.getAnalyzerStatus().getController());
        this.myPopup = this.myPopupBuilder.createPopup();
        this.myPopup.addListener(this.myPopupListener);
        this.myPopup.addListener((JBPopupListener)this.myPopupState);
        this.myEditor.getComponent().addAncestorListener(this.myAncestorListener);
        JComponent owner = (JComponent)event.getComponent();
        Dimension size = this.myContent.getPreferredSize();
        size.width = Math.max(size.width, JBUIScale.scale((int)296));
        RelativePoint point = new RelativePoint((Component)owner, new Point(owner.getWidth() - owner.getInsets().right + JBUIScale.scale((int)6) - size.width, owner.getHeight() + JBUIScale.scale((int)6)));
        this.myPopup.setSize(size);
        this.myPopup.show(point);
    }

    void hidePopup() {
        if (this.myPopup != null && !this.myPopup.isDisposed()) {
            this.myPopup.cancel();
        }
        this.myPopup = null;
    }

    private AnalyzerStatus getAnalyzerStatus() {
        return this.statusSupplier.get();
    }

    private void updateContentPanel(@NotNull UIController controller) {
        List passes = this.getAnalyzerStatus().getPasses();
        Set presentableNames = ContainerUtil.map2Set((Collection)passes, p -> p.getPresentableName());
        if (!presentableNames.isEmpty() && this.myProgressBarMap.keySet().equals(presentableNames)) {
            for (PassWrapper pass : passes) {
                this.myProgressBarMap.get(pass.getPresentableName()).setValue(pass.toPercent());
            }
            return;
        }
        this.myContent.removeAll();
        this.levelLinks.clear();
        GridBag gc = new GridBag().nextLine().next().anchor(21).weightx(1.0).fillCellHorizontally().insets(10, 10, 10, 0);
        boolean hasTitle = StringUtil.isNotEmpty((String)this.getAnalyzerStatus().getTitle());
        if (hasTitle) {
            this.myContent.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)this.getAnalyzerStatus().getTitle())), gc);
        } else if (StringUtil.isNotEmpty((String)this.getAnalyzerStatus().getDetails())) {
            this.myContent.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)this.getAnalyzerStatus().getDetails())), gc);
        } else if (this.getAnalyzerStatus().getExpandedStatus().size() > 0 && this.getAnalyzerStatus().getAnalyzingType() != AnalyzingType.EMPTY) {
            this.myContent.add((Component)this.createDetailsPanel(), gc);
        }
        Presentation presentation2 = new Presentation();
        presentation2.setIcon(AllIcons.Actions.More);
        presentation2.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
        List actions = controller.getActions();
        if (!actions.isEmpty()) {
            ActionButton menuButton = new ActionButton((AnAction)new MenuAction(actions, this.compactViewAction), presentation2, "EditorPopup", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.myContent.add((Component)menuButton, gc.next().anchor(22).weightx(0.0).insets(10, 6, 10, 6));
        }
        this.myProgressBarMap.clear();
        NonOpaquePanel myProgressPanel = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        GridBag progressGC = new GridBag();
        for (PassWrapper pass : passes) {
            myProgressPanel.add((Component)new JLabel(pass.getPresentableName() + ": "), progressGC.nextLine().next().anchor(21).weightx(0.0).insets(0, 10, 0, 6));
            JProgressBar pb = new JProgressBar(0, 100);
            pb.setValue(pass.toPercent());
            myProgressPanel.add((Component)pb, progressGC.next().anchor(21).weightx(1.0).fillCellHorizontally().insets(0, 0, 0, 6));
            this.myProgressBarMap.put(pass.getPresentableName(), pb);
        }
        this.myContent.add((Component)myProgressPanel, gc.nextLine().next().anchor(21).fillCellHorizontally().coverLine().weightx(1.0));
        if (hasTitle) {
            int topIndent = !this.myProgressBarMap.isEmpty() ? 10 : 0;
            gc.nextLine().next().anchor(21).fillCellHorizontally().coverLine().weightx(1.0).insets(topIndent, 10, 10, 6);
            if (StringUtil.isNotEmpty((String)this.getAnalyzerStatus().getDetails())) {
                this.myContent.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)this.getAnalyzerStatus().getDetails())), gc);
            } else if (this.getAnalyzerStatus().getExpandedStatus().size() > 0 && this.getAnalyzerStatus().getAnalyzingType() != AnalyzingType.EMPTY) {
                this.myContent.add((Component)this.createDetailsPanel(), gc);
            }
        }
        this.myContent.add((Component)this.createLowerPanel(controller), gc.nextLine().next().anchor(21).fillCellHorizontally().coverLine().weightx(1.0));
    }

    void updateVisiblePopup() {
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.updateContentPanel(this.getAnalyzerStatus().getController());
            Dimension size = this.myContent.getPreferredSize();
            size.width = Math.max(size.width, JBUIScale.scale((int)296));
            this.myPopup.setSize(size);
        }
    }

    @NotNull
    private JComponent createDetailsPanel() {
        StringBuilder text = new StringBuilder();
        for (int i2 = 0; i2 < this.getAnalyzerStatus().getExpandedStatus().size(); ++i2) {
            boolean last = i2 == this.getAnalyzerStatus().getExpandedStatus().size() - 1;
            StatusItem item = (StatusItem)this.getAnalyzerStatus().getExpandedStatus().get(i2);
            text.append(item.getText()).append(" ").append(item.getType());
            if (!last) {
                text.append(", ");
                continue;
            }
            if (this.getAnalyzerStatus().getAnalyzingType() == AnalyzingType.COMPLETE) continue;
            text.append(" ").append(EditorBundle.message((String)"iw.found.so.far.suffix", (Object[])new Object[0]));
        }
        return new JLabel(text.toString());
    }

    @NotNull
    private JPanel createLowerPanel(@NotNull UIController controller) {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gc = new GridBag().nextLine();
        if (PowerSaveMode.isEnabled()) {
            panel2.add((Component)((Object)new TrackableLinkLabel(EditorBundle.message((String)"iw.disable.powersave", (Object[])new Object[0]), () -> {
                PowerSaveMode.setEnabled((boolean)false);
                this.hidePopup();
            })), gc.next().anchor(21));
        } else {
            List levels = controller.getHighlightLevels();
            if (levels.size() == 1) {
                JLabel highlightLabel = new JLabel(EditorBundle.message((String)"iw.highlight.label", (Object[])new Object[0]) + " ");
                highlightLabel.setForeground(JBUI.CurrentTheme.Link.linkColor());
                panel2.add((Component)highlightLabel, gc.next().anchor(21));
                DropDownLink<InspectionsLevel> link = this.createDropDownLink((LanguageHighlightLevel)levels.get(0), controller);
                this.levelLinks.add(link);
                panel2.add((Component)link, gc.next());
            } else if (levels.size() > 1) {
                for (LanguageHighlightLevel level : levels) {
                    JLabel highlightLabel = new JLabel(level.getLangID() + ": ");
                    highlightLabel.setForeground(JBUI.CurrentTheme.Link.linkColor());
                    panel2.add((Component)highlightLabel, gc.next().anchor((int)21).gridx > 0 ? gc.insetLeft(8) : gc);
                    DropDownLink<InspectionsLevel> link = this.createDropDownLink(level, controller);
                    this.levelLinks.add(link);
                    panel2.add((Component)link, gc.next());
                }
            }
        }
        panel2.add(Box.createHorizontalGlue(), gc.next().fillCellHorizontally().weightx(1.0));
        controller.fillHectorPanels((Container)panel2, gc);
        panel2.setOpaque(true);
        panel2.setBackground(UIUtil.getToolTipActionBackground());
        panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        return panel2;
    }

    @NotNull
    private DropDownLink<InspectionsLevel> createDropDownLink(@NotNull LanguageHighlightLevel level, @NotNull UIController controller) {
        return new DropDownLink((Object)level.getLevel(), controller.getAvailableLevels(), inspectionsLevel -> {
            controller.setHighLightLevel(level.copy(level.getLangID(), inspectionsLevel));
            this.myContent.revalidate();
            Dimension size = this.myContent.getPreferredSize();
            size.width = Math.max(size.width, JBUIScale.scale((int)296));
            this.myPopup.setSize(size);
            FeatureUsageData data2 = new FeatureUsageData().addProject(this.myEditor.getProject()).addLanguage(level.getLangID()).addData("level", inspectionsLevel.toString());
            FUCounterUsageLogger.getInstance().logEvent("inspection.widget", "highlight.level.changed", data2);
        }, true);
    }

    private static class TrackableLinkLabel
    extends LinkLabel<Object> {
        private InputEvent myEvent;

        private TrackableLinkLabel(@NotNull String text, @NotNull Runnable action2) {
            super(text, null);
            this.setListener((__, ___) -> {
                action2.run();
                ActionsCollector.getInstance().record(null, this.myEvent, ((Object)((Object)this)).getClass());
            }, null);
        }

        public void doClick(InputEvent e) {
            this.myEvent = e;
            super.doClick(e);
        }
    }

    private static class MenuAction
    extends DefaultActionGroup
    implements HintManagerImpl.ActionToIgnore {
        private MenuAction(@NotNull List<? extends AnAction> actions, @NotNull AnAction compactViewAction) {
            this.setPopup(true);
            this.addAll(actions);
            this.add(compactViewAction);
        }
    }
}

