/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.impl.ImaginaryCaretModel;
import com.intellij.openapi.editor.impl.ImaginaryScrollingModel;
import com.intellij.openapi.editor.impl.ImaginarySelectionModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImaginaryEditor
extends UserDataHolderBase
implements Editor {
    private final ImaginaryCaretModel myCaretModel;
    private final ImaginarySelectionModel mySelectionModel;
    private final Project myProject;
    @NotNull
    private final Document myDocument;

    public ImaginaryEditor(@NotNull Project project, @NotNull Document document) {
        this.myProject = project;
        this.myDocument = document;
        this.myCaretModel = new ImaginaryCaretModel(this);
        this.mySelectionModel = new ImaginarySelectionModel(this);
    }

    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    @NotNull
    public CaretModel getCaretModel() {
        return this.myCaretModel;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    protected RuntimeException notImplemented() {
        return new UnsupportedOperationException();
    }

    public boolean isViewer() {
        throw this.notImplemented();
    }

    @NotNull
    public JComponent getComponent() {
        throw this.notImplemented();
    }

    @NotNull
    public JComponent getContentComponent() {
        throw this.notImplemented();
    }

    public void setBorder(@Nullable Border border) {
        throw this.notImplemented();
    }

    public Insets getInsets() {
        throw this.notImplemented();
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        throw this.notImplemented();
    }

    @NotNull
    public FoldingModel getFoldingModel() {
        throw this.notImplemented();
    }

    @NotNull
    public ScrollingModel getScrollingModel() {
        return new ImaginaryScrollingModel(this);
    }

    @NotNull
    public SoftWrapModel getSoftWrapModel() {
        throw this.notImplemented();
    }

    @NotNull
    public EditorSettings getSettings() {
        throw this.notImplemented();
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        throw this.notImplemented();
    }

    public int getLineHeight() {
        throw this.notImplemented();
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        throw this.notImplemented();
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        throw this.notImplemented();
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        throw this.notImplemented();
    }

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition pos) {
        throw this.notImplemented();
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        throw this.notImplemented();
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        return this.logicalToVisualPosition(this.offsetToLogicalPosition(offset));
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        return this.offsetToVisualPosition(offset);
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        throw this.notImplemented();
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        throw this.notImplemented();
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        throw this.notImplemented();
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        throw this.notImplemented();
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        throw this.notImplemented();
    }

    public boolean isDisposed() {
        return false;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isInsertMode() {
        return false;
    }

    public boolean isColumnMode() {
        return false;
    }

    public boolean isOneLineMode() {
        throw this.notImplemented();
    }

    @NotNull
    public EditorGutter getGutter() {
        throw this.notImplemented();
    }

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        throw this.notImplemented();
    }

    public void setHeaderComponent(@Nullable JComponent header2) {
        throw this.notImplemented();
    }

    public boolean hasHeaderComponent() {
        throw this.notImplemented();
    }

    @Nullable
    public JComponent getHeaderComponent() {
        throw this.notImplemented();
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        throw this.notImplemented();
    }

    @NotNull
    public InlayModel getInlayModel() {
        throw this.notImplemented();
    }

    @NotNull
    public EditorKind getEditorKind() {
        throw this.notImplemented();
    }
}

