/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.ImaginaryCaretModel;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImaginaryCaret
extends UserDataHolderBase
implements Caret {
    private final ImaginaryCaretModel myCaretModel;
    private int myStart;
    private int myEnd;

    ImaginaryCaret(ImaginaryCaretModel caretModel) {
        this.myCaretModel = caretModel;
    }

    public int getSelectionStart() {
        return this.myStart;
    }

    public int getSelectionEnd() {
        return this.myEnd;
    }

    public boolean hasSelection() {
        return false;
    }

    @NotNull
    public ImaginaryEditor getEditor() {
        return this.myCaretModel.getEditor();
    }

    @NotNull
    public CaretModel getCaretModel() {
        return this.myCaretModel;
    }

    public int getOffset() {
        return this.myStart;
    }

    public void moveToOffset(int offset) {
        this.myStart = this.myEnd = offset;
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.myStart = this.myEnd = offset;
    }

    private RuntimeException notImplemented() {
        return this.getEditor().notImplemented();
    }

    public boolean isValid() {
        throw this.notImplemented();
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        throw this.notImplemented();
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        this.moveToOffset(this.getEditor().logicalPositionToOffset(pos));
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        this.moveToOffset(this.getEditor().visualPositionToOffset(pos));
    }

    public boolean isUpToDate() {
        throw this.notImplemented();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        return this.getEditor().offsetToLogicalPosition(this.myStart);
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        throw this.notImplemented();
    }

    public int getVisualLineStart() {
        throw this.notImplemented();
    }

    public int getVisualLineEnd() {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        throw this.notImplemented();
    }

    @Nullable
    public String getSelectedText() {
        return this.getEditor().getDocument().getText(new TextRange(this.myStart, this.myEnd));
    }

    public int getLeadSelectionOffset() {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        throw this.notImplemented();
    }

    public void setSelection(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > endOffset) {
            throw new IllegalArgumentException();
        }
        this.myStart = startOffset;
        this.myEnd = endOffset;
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        throw this.notImplemented();
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        throw this.notImplemented();
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        throw this.notImplemented();
    }

    public void removeSelection() {
        this.myStart = this.myEnd;
    }

    public void selectLineAtCaret() {
        throw this.notImplemented();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        throw this.notImplemented();
    }

    @Nullable
    public Caret clone(boolean above) {
        throw this.notImplemented();
    }

    public boolean isAtRtlLocation() {
        throw this.notImplemented();
    }

    public boolean isAtBidiRunBoundary() {
        throw this.notImplemented();
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        throw this.notImplemented();
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        throw this.notImplemented();
    }

    public void dispose() {
        throw this.notImplemented();
    }
}

