/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.util.text.CharArrayIterator;
import com.intellij.util.text.CharSequenceIterator;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontFallbackIterator {
    private static final char COMPLEX_CHAR_START = '\u0300';
    private final BreakAtEveryCharacterIterator myTrivialBreaker = new BreakAtEveryCharacterIterator();
    private FontPreferences myFontPreferences = new FontPreferencesImpl();
    private int myFontStyle = 0;
    private FontRenderContext myFontRenderContext;
    private char[] myTextAsArray;
    private CharSequence myTextAsCharSequence;
    private BreakIterator myIterator;
    private int myStart;
    private int myEnd;
    private FontInfo myFontInfo;
    private FontInfo myNextFontInfo;

    public FontFallbackIterator setPreferredFonts(@NotNull FontPreferences fontPreferences) {
        this.myFontPreferences = fontPreferences;
        return this;
    }

    public FontFallbackIterator setPreferredFont(@NotNull String familyName, int size) {
        FontPreferencesImpl preferences = new FontPreferencesImpl();
        preferences.register(familyName, size);
        this.myFontPreferences = preferences;
        return this;
    }

    public FontFallbackIterator setFontStyle(@JdkConstants.FontStyle int fontStyle) {
        this.myFontStyle = fontStyle;
        return this;
    }

    public FontFallbackIterator setFontRenderContext(@Nullable FontRenderContext fontRenderContext) {
        this.myFontRenderContext = fontRenderContext;
        return this;
    }

    public void start(@NotNull CharSequence text, int start2, int end) {
        assert (0 <= start2 && start2 <= end && end <= text.length()) : "Text length: " + text.length() + ", start: " + start2 + ", end: " + end;
        CharSequenceIterator characterIterator = null;
        for (int i2 = start2; i2 < end; ++i2) {
            if (text.charAt(i2) < '\u0300') continue;
            characterIterator = new CharSequenceIterator(text, start2, end);
            break;
        }
        this.doStart(text, null, (CharacterIterator)characterIterator, start2, end);
    }

    public void start(char @NotNull [] text, int start2, int end) {
        assert (0 <= start2 && start2 <= end && end <= text.length) : "Text length: " + text.length + ", start: " + start2 + ", end: " + end;
        CharArrayIterator characterIterator = null;
        for (int i2 = start2; i2 < end; ++i2) {
            if (text[i2] < '\u0300') continue;
            characterIterator = new CharArrayIterator(text, start2, end);
            break;
        }
        this.doStart(null, text, (CharacterIterator)characterIterator, start2, end);
    }

    private void doStart(CharSequence textAsCharSequence, char[] textAsArray, CharacterIterator characterIterator, int start2, int end) {
        this.myTextAsCharSequence = textAsCharSequence;
        this.myTextAsArray = textAsArray;
        if (characterIterator == null) {
            this.myTrivialBreaker.setRange(start2, end);
            this.myIterator = this.myTrivialBreaker;
        } else {
            this.myIterator = BreakIterator.getCharacterInstance();
            this.myIterator.setText(characterIterator);
        }
        this.myStart = this.myEnd = this.myIterator.first();
        assert (this.myStart == start2);
        this.myNextFontInfo = null;
        this.myFontInfo = null;
        this.advance();
    }

    public boolean atEnd() {
        return this.myStart == this.myEnd;
    }

    public void advance() {
        int end;
        this.myStart = this.myEnd;
        this.myEnd = this.myIterator.current();
        this.myFontInfo = this.myNextFontInfo;
        while ((end = this.myIterator.next()) != -1) {
            this.myNextFontInfo = this.getFontAbleToDisplay(this.myEnd, end);
            if (this.myFontInfo == null) {
                this.myFontInfo = this.myNextFontInfo;
            }
            if (this.myNextFontInfo.equals(this.myFontInfo)) {
                this.myEnd = end;
                continue;
            }
            return;
        }
    }

    private FontInfo getFontAbleToDisplay(int start2, int end) {
        if (this.myTextAsCharSequence == null) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(this.myTextAsArray, start2, end, this.myFontStyle, this.myFontPreferences, this.myFontRenderContext);
        }
        return ComplementaryFontsRegistry.getFontAbleToDisplay(this.myTextAsCharSequence, start2, end, this.myFontStyle, this.myFontPreferences, this.myFontRenderContext);
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    @NotNull
    public FontInfo getFontInfo() {
        if (this.myFontRenderContext == null) {
            throw new IllegalStateException("FontRenderContext must be set to generate FontInfo");
        }
        return this.myFontInfo;
    }

    @NotNull
    public Font getFont() {
        return this.myFontInfo.getFont();
    }

    private static class BreakAtEveryCharacterIterator
    extends BreakIterator {
        private int myStart;
        private int myEnd;
        private int myCurrent;

        private BreakAtEveryCharacterIterator() {
        }

        public void setRange(int start2, int end) {
            this.myStart = start2;
            this.myEnd = end;
        }

        @Override
        public int first() {
            this.myCurrent = this.myStart;
            return this.myCurrent;
        }

        @Override
        public int last() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int next(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int next() {
            return this.myCurrent >= this.myEnd ? -1 : (this.myCurrent = this.myCurrent + 1);
        }

        @Override
        public int previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int following(int offset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int current() {
            return this.myCurrent;
        }

        @Override
        public CharacterIterator getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setText(CharacterIterator newText) {
            throw new UnsupportedOperationException();
        }
    }
}

