/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FocusRegion;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusModeModel
implements Disposable {
    public static final Key<TextAttributes> FOCUS_MODE_ATTRIBUTES = Key.create((String)"editor.focus.mode.attributes");
    public static final int LAYER = 10000;
    private final List<RangeHighlighter> myFocusModeMarkup = new SmartList();
    @NotNull
    private final EditorImpl myEditor;
    private RangeMarker myFocusModeRange;
    private final List<FocusModeModelListener> mySegmentListeners = new SmartList();
    private final RangeMarkerTree<FocusRegion> myFocusMarkerTree;

    public FocusModeModel(@NotNull EditorImpl editor) {
        this.myEditor = editor;
        this.myFocusMarkerTree = new RangeMarkerTree(editor.getDocument());
        this.myEditor.getScrollingModel().addVisibleAreaListener(e -> {
            AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
            if (event instanceof MouseEvent && !EditorUtil.isPrimaryCaretVisible(this.myEditor)) {
                this.clearFocusMode();
            } else {
                this.myEditor.applyFocusMode();
            }
        });
        final CaretModelImpl caretModel = this.myEditor.getCaretModel();
        caretModel.addCaretListener(new CaretListener(){

            public void caretAdded(@NotNull CaretEvent event) {
                this.process(event);
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                this.process(event);
            }

            public void caretRemoved(@NotNull CaretEvent event) {
                this.process(event);
            }

            private void process(@NotNull CaretEvent event) {
                Caret caret = event.getCaret();
                if (caret == caretModel.getPrimaryCaret()) {
                    FocusModeModel.this.applyFocusMode(caret);
                }
            }
        });
        this.myEditor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                FocusModeModel.this.myEditor.applyFocusMode();
            }
        });
    }

    public RangeMarker getFocusModeRange() {
        return this.myFocusModeRange;
    }

    public void applyFocusMode(@NotNull Caret caret) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        RangeMarkerEx[] startRange = new RangeMarkerEx[1];
        RangeMarkerEx[] endRange = new RangeMarkerEx[1];
        this.myFocusMarkerTree.processContaining(caret.getSelectionStart(), (Processor<FocusRegion>)((Processor)startMarker -> {
            if (startRange[0] == null || startRange[0].getStartOffset() < startMarker.getStartOffset()) {
                startRange[0] = startMarker;
            }
            return true;
        }));
        this.myFocusMarkerTree.processContaining(caret.getSelectionEnd(), (Processor<FocusRegion>)((Processor)endMarker -> {
            if (endRange[0] == null || endRange[0].getEndOffset() > endMarker.getEndOffset()) {
                endRange[0] = endMarker;
            }
            return true;
        }));
        this.clearFocusMode();
        if (startRange[0] != null && endRange[0] != null) {
            this.applyFocusMode(this.enlargeFocusRangeIfNeeded((Segment)new TextRange(startRange[0].getStartOffset(), endRange[0].getEndOffset())));
        }
    }

    public void clearFocusMode() {
        this.myFocusModeMarkup.forEach(arg_0 -> ((MarkupModelEx)this.myEditor.getMarkupModel()).removeHighlighter(arg_0));
        this.myFocusModeMarkup.clear();
        if (this.myFocusModeRange != null) {
            this.myFocusModeRange.dispose();
            this.myFocusModeRange = null;
        }
    }

    public boolean isInFocusMode(@NotNull RangeMarker region) {
        return this.myFocusModeRange != null && !FocusModeModel.intersects(this.myFocusModeRange, region);
    }

    @NotNull
    public FocusRegion createFocusRegion(int start2, int end) {
        FocusRegion marker = new FocusRegion(this.myEditor, start2, end);
        this.myFocusMarkerTree.addInterval(marker, start2, end, false, false, true, 0);
        this.mySegmentListeners.forEach(l -> l.focusRegionAdded(marker));
        return marker;
    }

    @Nullable
    public FocusRegion findFocusRegion(int start2, int end) {
        FocusRegion[] found = new FocusRegion[1];
        this.myFocusMarkerTree.processOverlappingWith(start2, end, (Processor<FocusRegion>)((Processor)range2 -> {
            if (range2.getStartOffset() == start2 && range2.getEndOffset() == end) {
                found[0] = range2;
                return false;
            }
            return true;
        }));
        return found[0];
    }

    public void removeFocusRegion(FocusRegion marker) {
        boolean removed = this.myFocusMarkerTree.removeInterval(marker);
        if (removed) {
            this.mySegmentListeners.forEach(l -> l.focusRegionRemoved(marker));
        }
    }

    public void addFocusSegmentListener(FocusModeModelListener newListener, Disposable disposable2) {
        this.mySegmentListeners.add(newListener);
        Disposer.register((Disposable)disposable2, () -> this.mySegmentListeners.remove(newListener));
    }

    @NotNull
    private Segment enlargeFocusRangeIfNeeded(Segment range2) {
        int originalEnd;
        int end;
        DocumentEx document;
        int originalStart = range2.getStartOffset();
        int start2 = DocumentUtil.getLineStartOffset(originalStart, document = this.myEditor.getDocument());
        if (start2 < originalStart) {
            range2 = new TextRange(start2, range2.getEndOffset());
        }
        if ((end = DocumentUtil.getLineEndOffset(originalEnd = range2.getEndOffset(), document)) >= originalEnd) {
            range2 = new TextRange(range2.getStartOffset(), end < document.getTextLength() ? end + 1 : end);
        }
        return range2;
    }

    private void applyFocusMode(@NotNull Segment focusRange) {
        EditorColorsScheme scheme = (EditorColorsScheme)ObjectUtils.notNull((Object)this.myEditor.getColorsScheme(), (Object)EditorColorsManager.getInstance().getGlobalScheme());
        Color background = scheme.getDefaultBackground();
        Color foreground = Registry.getColor((String)(ColorUtil.isDark((Color)background) ? "editor.focus.mode.color.dark" : "editor.focus.mode.color.light"), (Color)Color.GRAY);
        TextAttributes attributes = new TextAttributes(foreground, background, background, EffectType.LINE_UNDERSCORE, 0);
        this.myEditor.putUserData(FOCUS_MODE_ATTRIBUTES, attributes);
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        DocumentEx document = this.myEditor.getDocument();
        int textLength = document.getTextLength();
        int start2 = focusRange.getStartOffset();
        int end = focusRange.getEndOffset();
        if (start2 <= textLength) {
            this.myFocusModeMarkup.add(markupModel.addRangeHighlighter(0, start2, 10000, attributes, HighlighterTargetArea.EXACT_RANGE));
        }
        if (end <= textLength) {
            this.myFocusModeMarkup.add(markupModel.addRangeHighlighter(end, textLength, 10000, attributes, HighlighterTargetArea.EXACT_RANGE));
        }
        this.myFocusModeRange = document.createRangeMarker(start2, end);
    }

    public void dispose() {
        this.myFocusMarkerTree.dispose(this.myEditor.getDocument());
    }

    private static boolean intersects(RangeMarker a, RangeMarker b) {
        return Math.max(a.getStartOffset(), b.getStartOffset()) < Math.min(a.getEndOffset(), b.getEndOffset());
    }

    public static interface FocusModeModelListener {
        public void focusRegionAdded(FocusRegion var1);

        public void focusRegionRemoved(FocusRegion var1);
    }
}

