/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import org.jetbrains.annotations.NotNull;

class ErrorStripeMarkerImpl
extends RangeMarkerImpl {
    private final RangeHighlighterEx myHighlighter;
    private int myLine;

    ErrorStripeMarkerImpl(@NotNull DocumentEx document, @NotNull RangeHighlighterEx highlighter) {
        super(document, highlighter.getStartOffset(), highlighter.getEndOffset(), false, true);
        this.myHighlighter = highlighter;
        if (highlighter.isPersistent()) {
            this.myLine = document.getLineNumber(highlighter.getStartOffset());
        }
    }

    @NotNull
    public RangeHighlighterEx getHighlighter() {
        return this.myHighlighter;
    }

    @Override
    public boolean isValid() {
        return this.myHighlighter.isValid() && super.isValid();
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (this.myHighlighter.isPersistent()) {
            this.myLine = this.persistentHighlighterUpdate(e, this.myLine, this.myHighlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE);
        } else {
            super.changedUpdateImpl(e);
        }
    }
}

