/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class EditorLastActionTracker {
    private String myLastActionId;
    private Editor myCurrentEditor;
    private Editor myLastEditor;

    @NotNull
    public static EditorLastActionTracker getInstance() {
        return (EditorLastActionTracker)ServiceManager.getService(EditorLastActionTracker.class);
    }

    @Nullable
    public String getLastActionId() {
        return this.myLastActionId;
    }

    private static String getActionId(AnAction action2) {
        return action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
    }

    private void doResetLastAction() {
        this.myLastActionId = null;
        this.myLastEditor = null;
    }

    @Nullable
    private static EditorLastActionTracker getTrackerIfCreated() {
        return (EditorLastActionTracker)ApplicationManager.getApplication().getServiceIfCreated(EditorLastActionTracker.class);
    }

    private static void resetLastAction() {
        EditorLastActionTracker tracker = EditorLastActionTracker.getTrackerIfCreated();
        if (tracker != null) {
            tracker.doResetLastAction();
        }
    }

    static final class MyEditorMouseListener
    implements EditorMouseListener {
        MyEditorMouseListener() {
        }

        public void mousePressed(@NotNull EditorMouseEvent e) {
            EditorLastActionTracker.resetLastAction();
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            EditorLastActionTracker.resetLastAction();
        }

        public void mouseReleased(@NotNull EditorMouseEvent e) {
            EditorLastActionTracker.resetLastAction();
        }
    }

    static final class MyAnActionListener
    implements AnActionListener {
        MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            EditorLastActionTracker tracker;
            Editor editor = (Editor)CommonDataKeys.HOST_EDITOR.getData(dataContext);
            EditorLastActionTracker editorLastActionTracker = tracker = editor == null ? EditorLastActionTracker.getTrackerIfCreated() : EditorLastActionTracker.getInstance();
            if (tracker == null) {
                return;
            }
            tracker.myCurrentEditor = editor;
            if (tracker.myCurrentEditor != tracker.myLastEditor) {
                tracker.doResetLastAction();
            }
        }

        public void afterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            EditorLastActionTracker tracker = EditorLastActionTracker.getInstance();
            tracker.myLastActionId = EditorLastActionTracker.getActionId(action2);
            tracker.myLastEditor = tracker.myCurrentEditor;
            tracker.myCurrentEditor = null;
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            EditorLastActionTracker.resetLastAction();
        }
    }

    static final class MyEditorFactoryListener
    implements EditorFactoryListener {
        MyEditorFactoryListener() {
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            EditorLastActionTracker tracker = EditorLastActionTracker.getInstance();
            EditorImpl killedEditor = (EditorImpl)event.getEditor();
            if (tracker.myCurrentEditor == killedEditor) {
                tracker.myCurrentEditor = null;
            }
            if (tracker.myLastEditor == killedEditor) {
                tracker.myLastEditor = null;
            }
        }
    }
}

