/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.MarkerTreeWithPartialSums;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import java.awt.Point;
import java.util.List;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BlockInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, BlockInlayImpl<?>>
implements IntSupplier {
    final boolean myShowAbove;
    final int myPriority;
    private int myHeightInPixels;
    private GutterIconRenderer myGutterIconRenderer;

    BlockInlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPrecedingText, boolean showAbove, int priority, @NotNull R renderer) {
        super(editor, offset, relatesToPrecedingText, renderer);
        this.myShowAbove = showAbove;
        this.myPriority = priority;
    }

    @Override
    MarkerTreeWithPartialSums<BlockInlayImpl<?>> getTree() {
        return this.myEditor.getInlayModel().myBlockElementsTree;
    }

    @Override
    void doUpdate() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels < 0) {
            throw PluginException.createByClass((String)("Non-negative width should be defined for a block element by " + this.myRenderer), null, this.myRenderer.getClass());
        }
        int oldHeightInPixels = this.myHeightInPixels;
        this.myHeightInPixels = this.myRenderer.calcHeightInPixels((Inlay)this);
        if (oldHeightInPixels != this.myHeightInPixels) {
            ((MarkerTreeWithPartialSums)this.getTree()).valueUpdated(this);
        }
        if (this.myHeightInPixels < 0) {
            throw PluginException.createByClass((String)("Non-negative height should be defined for a block element by " + this.myRenderer), null, this.myRenderer.getClass());
        }
        this.myGutterIconRenderer = this.myRenderer.calcGutterIconRenderer((Inlay)this);
    }

    @Override
    Point getPosition() {
        int visualLine = this.myEditor.offsetToVisualLine(this.getOffset());
        int y = this.myEditor.visualLineToY(visualLine);
        List<Inlay<?>> allInlays = this.myEditor.getInlayModel().getBlockElementsForVisualLine(visualLine, this.myShowAbove);
        if (this.myShowAbove) {
            boolean found = false;
            for (Inlay<?> inlay : allInlays) {
                if (inlay == this) {
                    found = true;
                }
                if (!found) continue;
                y -= inlay.getHeightInPixels();
            }
        } else {
            y += this.myEditor.getLineHeight();
            for (Inlay<?> inlay : allInlays) {
                if (inlay == this) break;
                y += inlay.getHeightInPixels();
            }
        }
        return new Point(this.myEditor.getContentComponent().getInsets().left, y);
    }

    public int getHeightInPixels() {
        return this.myHeightInPixels;
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        return this.myShowAbove ? Inlay.Placement.ABOVE_LINE : Inlay.Placement.BELOW_LINE;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        return this.myEditor.offsetToVisualPosition(this.getOffset());
    }

    @Override
    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    @Override
    public int getAsInt() {
        return this.myHeightInPixels;
    }

    @Override
    public String toString() {
        return "[Block inlay, offset=" + this.getOffset() + ", width=" + this.myWidthInPixels + ", height=" + this.myHeightInPixels + ", renderer=" + this.myRenderer + "]";
    }
}

