/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsSchemeImpl
extends AbstractColorsScheme
implements ExternalizableScheme {
    private final Map<String, TextAttributes> myAttributesTempMap = new ConcurrentHashMap<String, TextAttributes>();

    public EditorColorsSchemeImpl(EditorColorsScheme parentScheme) {
        super(parentScheme);
    }

    @Override
    public void copyTo(AbstractColorsScheme newScheme) {
        super.copyTo(newScheme);
        this.myAttributesTempMap.clear();
    }

    public void setAttributes(@NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        if (TextAttributesKey.isTemp((TextAttributesKey)key)) {
            this.myAttributesTempMap.put(key.getExternalName(), attributes);
        } else if (attributes == INHERITED_ATTRS_MARKER || !Comparing.equal((Object)attributes, (Object)this.getDirectlyDefinedAttributes(key))) {
            this.myAttributesMap.put(key.getExternalName(), attributes);
            this.myAttributesTempMap.clear();
        }
    }

    public void setColor(ColorKey key, Color color) {
        if (color == INHERITED_COLOR_MARKER || !EditorColorsSchemeImpl.colorsEqual(color, this.getDirectlyDefinedColor(key))) {
            this.myColorsMap.put(key, ObjectUtils.notNull((Object)color, (Object)NULL_COLOR_MARKER));
        }
    }

    public TextAttributes getAttributes(@Nullable TextAttributesKey key) {
        if (key != null) {
            if (TextAttributesKey.isTemp((TextAttributesKey)key)) {
                return this.myAttributesTempMap.get(key.getExternalName());
            }
            TextAttributes attributes = this.getDirectlyDefinedAttributes(key);
            if (attributes != null && attributes != INHERITED_ATTRS_MARKER) {
                return attributes;
            }
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            if (fallbackKey != null && (attributes = this.getFallbackAttributes(fallbackKey)) != null) {
                return attributes;
            }
        }
        return this.myParentScheme.getAttributes(key);
    }

    @Nullable
    public Color getColor(ColorKey key) {
        if (key != null) {
            Color color = this.getDirectlyDefinedColor(key);
            if (color == NULL_COLOR_MARKER) {
                return null;
            }
            if (color != null && color != INHERITED_COLOR_MARKER) {
                return color;
            }
            ColorKey fallbackKey = key.getFallbackColorKey();
            if (fallbackKey != null && (color = this.getFallbackColor(fallbackKey)) != null) {
                return color;
            }
        }
        return this.myParentScheme.getColor(key);
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this.myParentScheme);
        this.copyTo(newScheme);
        newScheme.setName(this.getName());
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }

    @Override
    protected boolean attributesEqual(AbstractColorsScheme otherScheme) {
        return this.compareAttributes(otherScheme, new ArrayList<Predicate<? super TextAttributesKey>>());
    }

    @Override
    protected boolean colorsEqual(AbstractColorsScheme otherScheme, @Nullable Predicate<ColorKey> colorKeyFilter) {
        ArrayList<Predicate<ColorKey>> filters = new ArrayList<Predicate<ColorKey>>();
        if (colorKeyFilter != null) {
            filters.add(colorKeyFilter);
        }
        return this.compareColors(otherScheme, filters);
    }

    private boolean compareAttributes(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Predicate<? super TextAttributesKey>> filters) {
        for (String keyName : this.myAttributesMap.keySet()) {
            TextAttributesKey key2 = TextAttributesKey.find((String)keyName);
            if (EditorColorsSchemeImpl.isTextAttributeKeyIgnored(filters, key2) || this.getAttributes(key2).equals((Object)otherScheme.getAttributes(key2))) continue;
            return false;
        }
        filters.add(key -> this.myAttributesMap.containsKey(key.getExternalName()));
        return !(this.myParentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.myParentScheme).compareAttributes(otherScheme, filters);
    }

    private static boolean isTextAttributeKeyIgnored(@NotNull Collection<? extends Predicate<? super TextAttributesKey>> filters, TextAttributesKey key) {
        for (Predicate<? super TextAttributesKey> predicate : filters) {
            if (!predicate.test((TextAttributesKey)key)) continue;
            return true;
        }
        return false;
    }

    private boolean compareColors(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Predicate<ColorKey>> filters) {
        for (ColorKey key2 : this.myColorsMap.keySet()) {
            Color thisColor = this.getColor(key2);
            Color otherColor = otherScheme.getColor(key2);
            if (!EditorColorsSchemeImpl.isColorKeyAccepted(filters, key2) || Comparing.equal((Object)thisColor, (Object)otherColor)) continue;
            return false;
        }
        filters.add(key -> !this.myColorsMap.containsKey(key));
        return !(this.myParentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.myParentScheme).compareColors(otherScheme, filters);
    }

    private static boolean isColorKeyAccepted(@NotNull Collection<? extends Predicate<ColorKey>> filters, @NotNull ColorKey key) {
        for (Predicate<ColorKey> predicate : filters) {
            if (predicate.test(key)) continue;
            return false;
        }
        return true;
    }
}

