/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.configurationStore.BundledSchemeEP;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeExtensionProvider;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.AdditionalTextAttributesEP;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ComponentTreeEventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.swing.UIManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="EditorColorsManagerImpl", storages={@Storage(value="colors.scheme.xml")}, additionalExportFile="colors")
public final class EditorColorsManagerImpl
extends EditorColorsManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(EditorColorsManagerImpl.class);
    private static final ExtensionPointName<BundledSchemeEP> BUNDLED_EP_NAME = ExtensionPointName.create((String)"com.intellij.bundledColorScheme");
    private final ComponentTreeEventDispatcher<EditorColorsListener> myTreeDispatcher = ComponentTreeEventDispatcher.create(EditorColorsListener.class);
    private final SchemeManager<EditorColorsScheme> mySchemeManager;
    static final String FILE_SPEC = "colors";
    private State myState = new State();
    private static final String TEMP_SCHEME_KEY = "TEMP_SCHEME_KEY";
    private static final String TEMP_SCHEME_FILE_KEY = "TEMP_SCHEME_FILE_KEY";

    public EditorColorsManagerImpl() {
        this(SchemeManagerFactory.getInstance());
    }

    @NonInjectable
    public EditorColorsManagerImpl(@NotNull SchemeManagerFactory schemeManagerFactory) {
        MultiMap<String, AdditionalTextAttributesEP> additionalTextAttributes = EditorColorsManagerImpl.collectAdditionalTextAttributesEPs();
        final class EditorColorSchemeProcessor
        extends LazySchemeProcessor<EditorColorsScheme, EditorColorsSchemeImpl>
        implements SchemeExtensionProvider {
            private final MultiMap<String, AdditionalTextAttributesEP> myAdditionalTextAttributes;

            EditorColorSchemeProcessor(MultiMap<String, AdditionalTextAttributesEP> additionalTextAttributes) {
                this.myAdditionalTextAttributes = additionalTextAttributes;
            }

            @Override
            @NotNull
            public EditorColorsSchemeImpl createScheme(@NotNull SchemeDataHolder<? super EditorColorsSchemeImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
                EditorColorsSchemeImpl scheme = isBundled ? new BundledScheme() : new EditorColorsSchemeImpl(null);
                scheme.readExternal(dataHolder.read());
                if (isBundled || ApplicationManager.getApplication().isUnitTestMode() && Boolean.valueOf(scheme.getMetaProperties().getProperty("forceOptimize")) == Boolean.TRUE) {
                    EditorColorsManagerImpl.loadAdditionalTextAttributesForScheme(scheme.myParentScheme, (MultiMap<String, AdditionalTextAttributesEP>)this.myAdditionalTextAttributes);
                    scheme.optimizeAttributeMap();
                }
                return scheme;
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull EditorColorsScheme scheme) {
                return scheme instanceof ReadOnlyColorsScheme ? SchemeState.NON_PERSISTENT : SchemeState.POSSIBLY_CHANGED;
            }

            @Override
            public void onCurrentSchemeSwitched(@Nullable EditorColorsScheme oldScheme, @Nullable EditorColorsScheme newScheme, boolean processChangeSynchronously) {
                if (processChangeSynchronously) {
                    this.handleCurrentSchemeSwitched(newScheme);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> this.handleCurrentSchemeSwitched(newScheme));
                }
            }

            private void handleCurrentSchemeSwitched(@Nullable EditorColorsScheme newScheme) {
                LafManager.getInstance().updateUI();
                EditorColorsManagerImpl.this.schemeChangedOrSwitched(newScheme);
            }

            @Override
            @NotNull
            @NonNls
            public String getSchemeExtension() {
                return ".icls";
            }

            @Override
            public boolean isSchemeEqualToBundled(@NotNull EditorColorsSchemeImpl scheme) {
                if (!scheme.getName().startsWith("_@user_")) {
                    return false;
                }
                AbstractColorsScheme bundledScheme = (AbstractColorsScheme)EditorColorsManagerImpl.this.mySchemeManager.findSchemeByName(scheme.getName().substring("_@user_".length()));
                if (bundledScheme == null) {
                    return false;
                }
                return scheme.settingsEqual(bundledScheme);
            }

            @Override
            public void reloaded(@NotNull SchemeManager<EditorColorsScheme> schemeManager2, @NotNull Collection<? extends EditorColorsScheme> schemes) {
                EditorColorsManagerImpl.this.loadBundledSchemes();
                EditorColorsManagerImpl.this.loadSchemesFromThemes();
                EditorColorsManagerImpl.this.initEditableDefaultSchemesCopies();
                EditorColorsManagerImpl.this.initEditableBundledSchemesCopies();
            }
        }
        this.mySchemeManager = schemeManagerFactory.create(FILE_SPEC, new EditorColorSchemeProcessor(additionalTextAttributes));
        this.initDefaultSchemes();
        this.loadBundledSchemes();
        this.loadSchemesFromThemes();
        this.mySchemeManager.loadSchemes();
        this.loadRemainAdditionalTextAttributes(additionalTextAttributes);
        this.initEditableDefaultSchemesCopies();
        this.initEditableBundledSchemesCopies();
        this.resolveLinksToBundledSchemes();
        this.initScheme();
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                EditorColorsManagerImpl.this.reloadKeepingActiveScheme();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                EditorColorsManagerImpl.this.reloadKeepingActiveScheme();
            }
        });
    }

    private void reloadKeepingActiveScheme() {
        EditorColorsScheme scheme;
        String activeScheme = this.mySchemeManager.getCurrentSchemeName();
        this.mySchemeManager.reload();
        if (StringUtil.isNotEmpty((String)activeScheme) && (scheme = this.getScheme(activeScheme)) != null) {
            this.setGlobalScheme(scheme);
        }
    }

    private void initDefaultSchemes() {
        for (DefaultColorsScheme defaultScheme : DefaultColorSchemesManager.getInstance().getAllSchemes()) {
            this.mySchemeManager.addScheme(defaultScheme);
        }
    }

    private void initEditableDefaultSchemesCopies() {
        for (DefaultColorsScheme defaultScheme : DefaultColorSchemesManager.getInstance().getAllSchemes()) {
            if (!defaultScheme.hasEditableCopy()) continue;
            this.createEditableCopy(defaultScheme, defaultScheme.getEditableCopyName());
        }
    }

    private void initScheme() {
        String schemeName;
        LafManager lm;
        UIManager.LookAndFeelInfo laf;
        String wizardEditorScheme = WelcomeWizardUtil.getWizardEditorScheme();
        EditorColorsScheme scheme = null;
        if (wizardEditorScheme != null) {
            scheme = this.getScheme(wizardEditorScheme);
            LOG.assertTrue(scheme != null, (Object)("Wizard scheme " + wizardEditorScheme + " not found"));
        }
        if (scheme == null && (laf = (lm = LafManager.getInstance()).getCurrentLookAndFeel()) instanceof UIThemeBasedLookAndFeelInfo && (schemeName = ((UIThemeBasedLookAndFeelInfo)laf).getTheme().getEditorSchemeName()) != null) {
            scheme = this.getScheme(schemeName);
        }
        if (scheme == null) {
            scheme = StartupUiUtil.isUnderDarcula() ? this.getScheme("Darcula") : this.getDefaultScheme();
        }
        this.setGlobalSchemeInner(scheme);
    }

    private void loadBundledSchemes() {
        if (!EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            BUNDLED_EP_NAME.forEachExtensionSafe(ep2 -> this.mySchemeManager.loadBundledScheme(ep2.getPath() + ".xml", ep2));
        }
    }

    private void loadSchemesFromThemes() {
        if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            return;
        }
        for (UIManager.LookAndFeelInfo laf : LafManager.getInstance().getInstalledLookAndFeels()) {
            UITheme theme;
            String path;
            if (!(laf instanceof UIThemeBasedLookAndFeelInfo) || (path = (theme = ((UIThemeBasedLookAndFeelInfo)laf).getTheme()).getEditorScheme()) == null) continue;
            this.mySchemeManager.loadBundledScheme(path, theme);
        }
    }

    private void initEditableBundledSchemesCopies() {
        for (EditorColorsScheme scheme : this.mySchemeManager.getAllSchemes()) {
            if (!(scheme instanceof BundledScheme)) continue;
            this.createEditableCopy((BundledScheme)scheme, "_@user_" + scheme.getName());
        }
    }

    private void resolveLinksToBundledSchemes() {
        ArrayList<EditorColorsScheme> brokenSchemesList = new ArrayList<EditorColorsScheme>();
        for (EditorColorsScheme scheme : this.mySchemeManager.getAllSchemes()) {
            try {
                this.resolveSchemeParent(scheme);
            }
            catch (InvalidDataException e) {
                brokenSchemesList.add(scheme);
                String message = IdeBundle.message((String)"notification.content.color.scheme", (Object[])new Object[]{scheme.getName(), e.getMessage()});
                Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"notification.title.incompatible.color.scheme", (Object[])new Object[0]), message, NotificationType.ERROR));
            }
        }
        for (EditorColorsScheme brokenScheme : brokenSchemesList) {
            this.mySchemeManager.removeScheme(brokenScheme);
        }
    }

    public void resolveSchemeParent(@NotNull EditorColorsScheme scheme) {
        if (scheme instanceof AbstractColorsScheme && !(scheme instanceof ReadOnlyColorsScheme)) {
            ((AbstractColorsScheme)scheme).resolveParent(name -> this.mySchemeManager.findSchemeByName((String)name));
        }
    }

    private void createEditableCopy(@NotNull AbstractColorsScheme initialScheme, @NotNull String editableCopyName) {
        AbstractColorsScheme editableCopy = (AbstractColorsScheme)this.getScheme(editableCopyName);
        if (editableCopy == null) {
            editableCopy = (AbstractColorsScheme)initialScheme.clone();
            editableCopy.setName(editableCopyName);
            this.mySchemeManager.addScheme(editableCopy);
        }
        editableCopy.setCanBeDeleted(false);
    }

    public void schemeChangedOrSwitched(@Nullable EditorColorsScheme newScheme) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
            ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
        }
        ((EditorColorsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).globalSchemeChange(newScheme);
        ((EditorColorsListener)this.myTreeDispatcher.getMulticaster()).globalSchemeChange(newScheme);
    }

    public void handleThemeAdded(@NotNull UITheme theme) {
        String editorScheme = theme.getEditorScheme();
        if (editorScheme != null) {
            this.getSchemeManager().loadBundledScheme(editorScheme, theme);
            this.initEditableBundledSchemesCopies();
        }
    }

    public void handleThemeRemoved(@NotNull UITheme theme) {
        EditorColorsScheme scheme;
        String editorSchemeName = theme.getEditorSchemeName();
        if (editorSchemeName != null && (scheme = this.mySchemeManager.findSchemeByName(editorSchemeName)) != null) {
            this.mySchemeManager.removeScheme(scheme);
            String editableCopyName = EditorColorsManagerImpl.getEditableCopyName(scheme);
            if (editableCopyName != null) {
                this.mySchemeManager.removeScheme(editableCopyName);
            }
        }
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public TextAttributes getDefaultAttributes(@NotNull TextAttributesKey key) {
        boolean dark = StartupUiUtil.isUnderDarcula() && this.getScheme("Darcula") != null;
        return this.getScheme(dark ? "Darcula" : "Default").getAttributes(key);
    }

    @NotNull
    private static MultiMap<String, AdditionalTextAttributesEP> collectAdditionalTextAttributesEPs() {
        MultiMap schemeNameToAttributesFile = MultiMap.create();
        AdditionalTextAttributesEP.EP_NAME.forEachExtensionSafe(attributesEP -> schemeNameToAttributesFile.putValue((Object)attributesEP.scheme, (Object)attributesEP));
        return schemeNameToAttributesFile;
    }

    private void loadRemainAdditionalTextAttributes(@NotNull MultiMap<String, AdditionalTextAttributesEP> additionalTextAttributes) {
        for (Map.Entry entry : additionalTextAttributes.entrySet()) {
            String schemeName = (String)entry.getKey();
            EditorColorsScheme editorColorsScheme = this.mySchemeManager.findSchemeByName(schemeName);
            if (!(editorColorsScheme instanceof AbstractColorsScheme)) {
                if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) continue;
                LOG.warn("Cannot find scheme: " + schemeName + " from plugins: " + StringUtil.join((Collection)((Collection)entry.getValue()), ep2 -> ep2.getPluginDescriptor().getPluginId().getIdString(), (String)";"));
                continue;
            }
            EditorColorsManagerImpl.loadAdditionalTextAttributesForScheme((AbstractColorsScheme)editorColorsScheme, (Collection)entry.getValue());
        }
        additionalTextAttributes.clear();
    }

    private static void loadAdditionalTextAttributesForScheme(@Nullable EditorColorsScheme scheme, @NotNull MultiMap<String, AdditionalTextAttributesEP> additionalTextAttributes) {
        if (!(scheme instanceof AbstractColorsScheme)) {
            return;
        }
        Collection attributesEPs = additionalTextAttributes.remove((Object)scheme.getName());
        if (attributesEPs == null) {
            return;
        }
        EditorColorsManagerImpl.loadAdditionalTextAttributesForScheme((AbstractColorsScheme)scheme, attributesEPs);
    }

    private static void loadAdditionalTextAttributesForScheme(@NotNull AbstractColorsScheme scheme, @NotNull Collection<AdditionalTextAttributesEP> attributesEPs) {
        for (AdditionalTextAttributesEP attributesEP : attributesEPs) {
            URL resource = attributesEP.getLoaderForClass().getResource(attributesEP.file);
            if (resource == null) {
                LOG.warn("resource not found: " + attributesEP.file);
                continue;
            }
            try {
                Element root = JDOMUtil.load((InputStream)URLUtil.openStream((URL)resource));
                Element attrs = (Element)ObjectUtils.notNull((Object)root.getChild("attributes"), (Object)root);
                Element colors = root.getChild(FILE_SPEC);
                scheme.readAttributes(attrs);
                if (colors == null) continue;
                scheme.readColors(colors);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void addColorsScheme(@NotNull EditorColorsScheme scheme) {
        if (!this.isDefaultScheme(scheme) && !StringUtil.isEmpty((String)scheme.getName())) {
            this.mySchemeManager.addScheme(scheme);
        }
    }

    public void removeAllSchemes() {
    }

    public EditorColorsScheme @NotNull [] getAllSchemes() {
        EditorColorsScheme[] result2 = EditorColorsManagerImpl.getAllVisibleSchemes(this.mySchemeManager.getAllSchemes());
        Arrays.sort(result2, EditorColorSchemesComparator.INSTANCE);
        return result2;
    }

    private static EditorColorsScheme[] getAllVisibleSchemes(@NotNull Collection<? extends EditorColorsScheme> schemes) {
        ArrayList<EditorColorsScheme> visibleSchemes = new ArrayList<EditorColorsScheme>(schemes.size() - 1);
        for (EditorColorsScheme editorColorsScheme : schemes) {
            if (!AbstractColorsScheme.isVisible(editorColorsScheme)) continue;
            visibleSchemes.add(editorColorsScheme);
        }
        return visibleSchemes.toArray(new EditorColorsScheme[0]);
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme) {
        this.setGlobalScheme(scheme, false);
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme, boolean processChangeSynchronously) {
        boolean notify = LoadingState.COMPONENTS_LOADED.isOccurred();
        this.mySchemeManager.setCurrent(scheme == null ? this.getDefaultScheme() : scheme, notify, processChangeSynchronously);
    }

    private void setGlobalSchemeInner(@Nullable EditorColorsScheme scheme) {
        this.mySchemeManager.setCurrent(scheme == null ? this.getDefaultScheme() : scheme, false);
    }

    @NotNull
    private EditorColorsScheme getDefaultScheme() {
        DefaultColorsScheme defaultScheme = DefaultColorSchemesManager.getInstance().getFirstScheme();
        String editableCopyName = defaultScheme.getEditableCopyName();
        EditorColorsScheme editableCopy = this.getScheme(editableCopyName);
        assert (editableCopy != null) : "An editable copy of " + defaultScheme.getName() + " has not been initialized.";
        return editableCopy;
    }

    @NotNull
    public EditorColorsScheme getGlobalScheme() {
        EditorColorsScheme scheme = this.mySchemeManager.getActiveScheme();
        EditorColorsScheme editableCopy = this.getEditableCopy(scheme);
        if (editableCopy != null) {
            return editableCopy;
        }
        return scheme == null ? this.getDefaultScheme() : scheme;
    }

    @Nullable
    private EditorColorsScheme getEditableCopy(EditorColorsScheme scheme) {
        EditorColorsScheme editableCopy;
        if (EditorColorsManagerImpl.isTempScheme(scheme)) {
            return scheme;
        }
        String editableCopyName = EditorColorsManagerImpl.getEditableCopyName(scheme);
        if (editableCopyName != null && (editableCopy = this.getScheme(editableCopyName)) != null) {
            return editableCopy;
        }
        return null;
    }

    @Nullable
    private static String getEditableCopyName(EditorColorsScheme scheme) {
        String editableCopyName = null;
        if (scheme instanceof DefaultColorsScheme && ((DefaultColorsScheme)scheme).hasEditableCopy()) {
            editableCopyName = ((DefaultColorsScheme)scheme).getEditableCopyName();
        } else if (scheme instanceof BundledScheme) {
            editableCopyName = "_@user_" + scheme.getName();
        }
        return editableCopyName;
    }

    public EditorColorsScheme getScheme(@NotNull String schemeName) {
        return this.mySchemeManager.findSchemeByName(schemeName);
    }

    public void setUseOnlyMonospacedFonts(boolean value2) {
        this.myState.USE_ONLY_MONOSPACED_FONTS = value2;
    }

    public boolean isUseOnlyMonospacedFonts() {
        return this.myState.USE_ONLY_MONOSPACED_FONTS;
    }

    @Nullable
    public State getState() {
        String currentSchemeName = this.mySchemeManager.getCurrentSchemeName();
        if (currentSchemeName != null && !EditorColorsManagerImpl.isTempScheme(this.mySchemeManager.getActiveScheme())) {
            this.myState.colorScheme = currentSchemeName;
        }
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        this.setGlobalSchemeInner(this.myState.colorScheme == null ? this.getDefaultScheme() : this.mySchemeManager.findSchemeByName(this.myState.colorScheme));
    }

    public boolean isDefaultScheme(EditorColorsScheme scheme) {
        return scheme instanceof DefaultColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        EditorColorsScheme editableCopy;
        UITheme theme;
        String schemeName;
        EditorColorsScheme globalScheme;
        UIManager.LookAndFeelInfo lookAndFeelInfo = LafManager.getInstance().getCurrentLookAndFeel();
        EditorColorsScheme scheme = null;
        if (lookAndFeelInfo instanceof TempUIThemeBasedLookAndFeelInfo && EditorColorsManagerImpl.isTempScheme(globalScheme = EditorColorsManager.getInstance().getGlobalScheme())) {
            return globalScheme;
        }
        if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo && (schemeName = (theme = ((UIThemeBasedLookAndFeelInfo)lookAndFeelInfo).getTheme()).getEditorSchemeName()) != null) {
            scheme = this.getScheme(schemeName);
            assert (scheme != null) : "Theme " + theme.getName() + " refers to unknown color scheme " + schemeName;
        }
        if (scheme == null) {
            String schemeName2 = StartupUiUtil.isUnderDarcula() ? "Darcula" : "Default";
            DefaultColorSchemesManager colorSchemeManager = DefaultColorSchemesManager.getInstance();
            scheme = colorSchemeManager.getScheme(schemeName2);
            assert (scheme != null) : "The default scheme '" + schemeName2 + "' not found, available schemes: " + colorSchemeManager.listNames();
        }
        return (editableCopy = this.getEditableCopy(scheme)) != null ? editableCopy : scheme;
    }

    @NotNull
    public SchemeManager<EditorColorsScheme> getSchemeManager() {
        return this.mySchemeManager;
    }

    public static boolean isTempScheme(EditorColorsScheme scheme) {
        if (scheme == null) {
            return false;
        }
        return StringUtil.equals((CharSequence)scheme.getMetaProperties().getProperty(TEMP_SCHEME_KEY), (CharSequence)Boolean.TRUE.toString());
    }

    @Nullable
    public static Path getTempSchemeOriginalFilePath(EditorColorsScheme scheme) {
        String path;
        if (EditorColorsManagerImpl.isTempScheme(scheme) && (path = scheme.getMetaProperties().getProperty(TEMP_SCHEME_FILE_KEY)) != null) {
            return Paths.get(path, new String[0]);
        }
        return null;
    }

    public static void setTempScheme(EditorColorsScheme scheme, @Nullable VirtualFile originalSchemeFile) {
        if (scheme == null) {
            return;
        }
        scheme.getMetaProperties().setProperty(TEMP_SCHEME_KEY, Boolean.TRUE.toString());
        if (originalSchemeFile != null) {
            scheme.getMetaProperties().setProperty(TEMP_SCHEME_FILE_KEY, originalSchemeFile.getPath());
        }
    }

    static final class State {
        public boolean USE_ONLY_MONOSPACED_FONTS = true;
        @OptionTag(tag="global_color_scheme", nameAttribute="", valueAttribute="name")
        public String colorScheme;

        State() {
        }
    }

    static final class BundledScheme
    extends EditorColorsSchemeImpl
    implements ReadOnlyColorsScheme {
        BundledScheme() {
            super(null);
        }

        @Override
        public boolean isVisible() {
            return false;
        }
    }
}

