/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoveBomAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(RemoveBomAction.class);

    public RemoveBomAction() {
        super(IdeBundle.messagePointer((String)"remove.byte.order.mark", (Object[])new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 == null || files2.length == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = false;
        String fromWhere = files2[0].getName();
        for (VirtualFile file2 : files2) {
            if (file2.isDirectory()) {
                enabled = true;
                fromWhere = "all files in " + file2.getName() + " (recursively)" + (files2.length == 1 ? "" : " and others");
                break;
            }
            if (file2.getBOM() == null) continue;
            enabled = true;
            fromWhere = file2.getName() + (files2.length == 1 ? "" : " and others");
            break;
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()));
        String finalFromWhere = fromWhere;
        e.getPresentation().setDescription(IdeBundle.messagePointer((String)"remove.byte.order.mark.from", (Object[])new Object[]{finalFromWhere}));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 == null) {
            return;
        }
        final List<VirtualFile> filesToProcess = RemoveBomAction.getFilesWithBom(files2);
        if (filesToProcess.isEmpty()) {
            return;
        }
        final ArrayList filesUnableToProcess = new ArrayList();
        new Task.Backgroundable(RemoveBomAction.getEventProject((AnActionEvent)e), IdeBundle.message((String)"removing.byte.order.mark", (Object[])new Object[0]), true, () -> false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(false);
                for (int i2 = 0; i2 < filesToProcess.size(); ++i2) {
                    ProgressManager.checkCanceled();
                    VirtualFile virtualFile = (VirtualFile)filesToProcess.get(i2);
                    indicator.setFraction((double)i2 * 1.0 / (double)filesToProcess.size());
                    indicator.setText2(StringUtil.shortenPathWithEllipsis((String)virtualFile.getPath(), (int)40));
                    byte[] bom = virtualFile.getBOM();
                    if (!(virtualFile instanceof NewVirtualFile) || bom == null) continue;
                    if (RemoveBomAction.isBOMMandatory(virtualFile)) {
                        filesUnableToProcess.add(virtualFile);
                        continue;
                    }
                    RemoveBomAction.doRemoveBOM(virtualFile, bom);
                }
                if (!filesUnableToProcess.isEmpty()) {
                    String title = IdeBundle.message((String)"notification.title.was.unable.to.remove.bom.in", (Object[])new Object[]{filesUnableToProcess.size(), StringUtil.pluralize((String)"file", (int)filesUnableToProcess.size())});
                    String msg = IdeBundle.message((String)"notification.content.mandatory.bom.br", (Object[])new Object[]{filesUnableToProcess.size(), StringUtil.join((Collection)filesUnableToProcess, VirtualFile::getName, (String)"<br/>    ")});
                    Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Failed to remove BOM", (String)IdeBundle.message((String)"notification.group.failed.to.remove.bom", (Object[])new Object[0])), title, msg, NotificationType.ERROR));
                }
            }
        }.queue();
    }

    private static boolean isBOMMandatory(@NotNull VirtualFile file2) {
        return CharsetToolkit.getMandatoryBom((Charset)file2.getCharset()) != null;
    }

    private static void doRemoveBOM(@NotNull VirtualFile virtualFile, byte @NotNull [] bom) {
        virtualFile.setBOM(null);
        NewVirtualFile file2 = (NewVirtualFile)virtualFile;
        try {
            byte[] bytes = file2.contentsToByteArray();
            byte[] contentWithStrippedBom = new byte[bytes.length - bom.length];
            System.arraycopy(bytes, bom.length, contentWithStrippedBom, 0, contentWithStrippedBom.length);
            WriteAction.runAndWait(() -> file2.setBinaryContent(contentWithStrippedBom));
        }
        catch (IOException ex) {
            LOG.warn("Unexpected exception occurred on attempt to remove BOM from file " + file2, (Throwable)ex);
        }
    }

    @NotNull
    private static List<VirtualFile> getFilesWithBom(VirtualFile @NotNull [] roots) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile root : roots) {
            RemoveBomAction.getFilesWithBom(root, result2);
        }
        return result2;
    }

    private static void getFilesWithBom(@NotNull VirtualFile root, final @NotNull List<? super VirtualFile> result2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (!file2.isDirectory() && file2.getBOM() != null) {
                    result2.add(file2);
                }
                return true;
            }
        });
    }
}

