/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ProjectPathMacroManager
extends PathMacroManager {
    private final Project myProject;

    public ProjectPathMacroManager(@NotNull Project project) {
        super(PathMacros.getInstance());
        this.myProject = project;
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result2 = super.getExpandMacroMap();
        ProjectPathMacroManager.addFileHierarchyReplacements(result2, "PROJECT_DIR", this.myProject.getBasePath());
        if (!this.myProject.isDefault()) {
            result2.addMacroExpand("PROJECT_NAME", this.myProject.getName());
        }
        return result2;
    }

    @Override
    @NotNull
    protected ReplacePathToMacroMap computeReplacePathMap() {
        ReplacePathToMacroMap result2 = super.computeReplacePathMap();
        ProjectPathMacroManager.addFileHierarchyReplacements(result2, "PROJECT_DIR", this.myProject.getBasePath(), null);
        return result2;
    }
}

