/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class UpdatePluginsApp
implements ApplicationStarter {
    public String getCommandName() {
        return "update";
    }

    public void premain(@NotNull List<String> args) {
        System.setProperty("idea.skip.indices.initialization", "true");
    }

    public void main(String @NotNull [] args) {
        List availableUpdates;
        if (Boolean.getBoolean("idea.force.plugin.updates")) {
            UpdatePluginsApp.log("Updates applied.");
            System.exit(0);
        }
        if ((availableUpdates = UpdateChecker.getPluginUpdates()) == null) {
            UpdatePluginsApp.log("All plugins up to date.");
            System.exit(0);
            return;
        }
        Set filter2 = Stream.of(args).skip(1L).collect(Collectors.toSet());
        if (!filter2.isEmpty()) {
            availableUpdates = ContainerUtil.filter(availableUpdates, downloader -> filter2.contains(downloader.getId().getIdString()));
        }
        UpdatePluginsApp.log("Plugins to update:");
        availableUpdates.forEach(d -> UpdatePluginsApp.log("\t" + d.getPluginName()));
        if (UpdateInstaller.installPluginUpdates(availableUpdates, (ProgressIndicator)new EmptyProgressIndicator())) {
            System.exit(0);
        } else {
            UpdatePluginsApp.log("Update failed");
            System.exit(1);
        }
    }

    private static void log(String msg) {
        System.out.println(msg);
    }
}

