/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.util.CompressionUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class EditorChangeAction
extends BasicUndoableAction {
    private final int myOffset;
    private final int myMoveOffset;
    private final Object myOldString;
    private final Object myNewString;
    private final long myOldTimeStamp;
    private final long myNewTimeStamp;
    private final int myOldLength;
    private final int myNewLength;

    EditorChangeAction(@NotNull DocumentEvent e) {
        this((DocumentImpl)e.getDocument(), e.getOffset(), e.getMoveOffset(), e.getOldFragment(), e.getNewFragment(), e.getOldTimeStamp());
    }

    private EditorChangeAction(@NotNull DocumentImpl document, int offset, int moveOffset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp) {
        super(new Document[]{document});
        this.myOffset = offset;
        this.myMoveOffset = moveOffset;
        this.myOldString = CompressionUtil.compressStringRawBytes((CharSequence)oldString);
        this.myNewString = CompressionUtil.compressStringRawBytes((CharSequence)newString);
        this.myOldTimeStamp = oldTimeStamp;
        this.myNewTimeStamp = document.getModificationStamp();
        this.myNewLength = document.getTextLength();
        this.myOldLength = this.myNewLength - newString.length() + oldString.length();
    }

    public void undo() throws UnexpectedUndoException {
        this.doChange(this.myNewLength, this.myOldString, this.myOldLength, this.myOldTimeStamp);
    }

    public void redo() throws UnexpectedUndoException {
        this.doChange(this.myOldLength, this.myNewString, this.myNewLength, this.myNewTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChange(int fromLength, Object to, int toLength, long toTimeStamp) throws UnexpectedUndoException {
        DocumentImpl document = (DocumentImpl)this.getAffectedDocuments()[0].getDocument();
        assert (document != null);
        if (document.getTextLength() != fromLength) {
            throw new UnexpectedUndoException("Unexpected document state");
        }
        DocumentUndoProvider.startDocumentUndo(document);
        try {
            CharSequence toString2 = CompressionUtil.uncompressStringRawBytes((Object)to);
            int fromStringLength = toString2.length() - toLength + fromLength;
            document.replaceString(this.myOffset, this.myOffset + fromStringLength, this.myMoveOffset, toString2, toTimeStamp, false);
        }
        finally {
            DocumentUndoProvider.finishDocumentUndo(document);
        }
    }

    @NonNls
    public String toString() {
        return "editor change: '" + this.myOldString + "' to '" + this.myNewString + "' at: " + this.myOffset;
    }
}

