/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.FlushQueue;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LaterInvocator {
    private static final Logger LOG = Logger.getInstance(LaterInvocator.class);
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Map<Project, List<Dialog>> projectToModalEntities = ContainerUtil.createWeakMap();
    private static final Map<Project, Stack<ModalityState>> projectToModalEntitiesStack = ContainerUtil.createWeakMap();
    private static final Stack<ModalityStateEx> ourModalityStack = new Stack((Object[])new ModalityStateEx[]{(ModalityStateEx)ModalityState.NON_MODAL});
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
    private static final Executor ourWriteThreadExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Write Thread", (int)1);
    private static final FlushQueue ourEdtQueue = new FlushQueue(SwingUtilities::invokeLater);
    private static final FlushQueue ourWtQueue = new FlushQueue(r -> ourWriteThreadExecutor.execute(() -> ApplicationManagerEx.getApplicationEx().runIntendedWriteActionOnCurrentThread((Runnable)r)));
    private static final ConcurrentMap<Window, ModalityStateEx> ourWindowModalities = ContainerUtil.createConcurrentWeakMap();
    static final AtomicBoolean FLUSHER_SCHEDULED = new AtomicBoolean(false);
    private static final AtomicLong SUBMITTED_COUNT = new AtomicLong(0L);
    private static final AtomicInteger THREAD_TO_FLUSH = new AtomicInteger(0);

    private LaterInvocator() {
    }

    public static void addModalityStateListener(@NotNull ModalityStateListener listener2, @NotNull Disposable parentDisposable) {
        if (!ourModalityStateMulticaster.getListeners().contains(listener2)) {
            ourModalityStateMulticaster.addListener((EventListener)listener2, parentDisposable);
        }
    }

    @NotNull
    static ModalityStateEx modalityStateForWindow(@NotNull Window window) {
        return ourWindowModalities.computeIfAbsent(window, __ -> {
            Stack<ModalityStateEx> stack = ourModalityStack;
            synchronized (stack) {
                for (ModalityStateEx state : ourModalityStack) {
                    if (!state.getModalEntities().contains(window)) continue;
                    return state;
                }
            }
            Window owner = window.getOwner();
            ModalityStateEx ownerState = owner == null ? (ModalityStateEx)ModalityState.NON_MODAL : LaterInvocator.modalityStateForWindow(owner);
            return LaterInvocator.isModalDialog(window) ? ownerState.appendEntity(window) : ownerState;
        });
    }

    private static boolean isModalDialog(@NotNull Object window) {
        return window instanceof Dialog && ((Dialog)window).isModal();
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired, boolean onEdt) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        return LaterInvocator.invokeLater(runnable2, modalityState, expired, onEdt);
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, boolean onEdt) {
        return LaterInvocator.invokeLater(runnable2, modalityState, Conditions.alwaysFalse(), onEdt);
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, boolean onEdt) {
        ActionCallback callback2 = new ActionCallback();
        LaterInvocator.invokeLaterWithCallback(runnable2, modalityState, expired, callback2, onEdt);
        return callback2;
    }

    static void invokeLaterWithCallback(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @Nullable ActionCallback callback2, boolean onEdt) {
        if (expired.value(null)) {
            if (callback2 != null) {
                callback2.setRejected();
            }
            return;
        }
        FlushQueue.RunnableInfo runnableInfo = new FlushQueue.RunnableInfo(runnable2, modalityState, expired, callback2);
        LaterInvocator.pushRunnableToQueue(onEdt, runnableInfo);
    }

    static void invokeAndWait(final @NotNull Runnable runnable2, @NotNull ModalityState modalityState, boolean onEdt) {
        LOG.assertTrue(!LaterInvocator.isDispatchThread());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref exception = Ref.create();
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable2.run();
                }
                catch (Throwable e) {
                    exception.set((Object)e);
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                return "InvokeAndWait[" + runnable2 + "]";
            }
        };
        LaterInvocator.invokeLaterWithCallback(runnable1, modalityState, Conditions.alwaysFalse(), null, onEdt);
        semaphore.waitFor();
        if (!exception.isNull()) {
            Throwable cause = (Throwable)exception.get();
            if (SystemProperties.getBooleanProperty((String)"invoke.later.wrap.error", (boolean)true)) {
                throw new RuntimeException(cause);
            }
            ExceptionUtil.rethrow((Throwable)cause);
        }
    }

    public static void enterModal(@NotNull Object modalEntity) {
        ModalityStateEx state = LaterInvocator.getCurrentModalityState().appendEntity(modalEntity);
        if (LaterInvocator.isModalDialog(modalEntity)) {
            List<Object> currentEntities = state.getModalEntities();
            state = LaterInvocator.modalityStateForWindow((Window)modalEntity);
            state.forceModalEntities(currentEntities);
        }
        LaterInvocator.enterModal(modalEntity, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterModal(@NotNull Object modalEntity, @NotNull ModalityStateEx appendedState) {
        TransactionGuardImpl guard;
        LOG.assertTrue(LaterInvocator.isWriteThread(), (Object)"enterModal() should be invoked in write thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true, modalEntity);
        ourModalEntities.add(modalEntity);
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            ourModalityStack.push((Object)appendedState);
        }
        TransactionGuardImpl transactionGuardImpl = guard = LoadingState.COMPONENTS_LOADED.isOccurred() ? (TransactionGuardImpl)TransactionGuard.getInstance() : null;
        if (guard != null) {
            guard.enteredModality(appendedState);
        }
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    public static void enterModal(Project project, @NotNull Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + dialog2.getName() + " ; for project: " + project.getName());
        }
        if (project == null) {
            LaterInvocator.enterModal(dialog2);
            return;
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true, (Object)dialog2);
        List<Dialog> modalEntitiesList = projectToModalEntities.getOrDefault(project, ContainerUtil.createLockFreeCopyOnWriteList());
        projectToModalEntities.put(project, modalEntitiesList);
        modalEntitiesList.add(dialog2);
        Stack<ModalityState> modalEntitiesStack = projectToModalEntitiesStack.getOrDefault(project, (Stack<ModalityState>)new Stack((Object[])new ModalityState[]{ModalityState.NON_MODAL}));
        projectToModalEntitiesStack.put(project, modalEntitiesStack);
        modalEntitiesStack.push((Object)new ModalityStateEx(ArrayUtil.toObjectArray(ourModalEntities)));
    }

    @ApiStatus.Internal
    public static void markTransparent(@NotNull ModalityState state) {
        ((ModalityStateEx)state).markTransparent();
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    public static void leaveModal(Project project, @NotNull Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isWriteThread(), (Object)"leaveModal() should be invoked in write thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + dialog2.getName() + " ; for project: " + project.getName());
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false, (Object)dialog2);
        int index = ourModalEntities.indexOf(dialog2);
        if (index != -1) {
            LaterInvocator.removeModality(dialog2, index);
        } else if (project != null) {
            List<Dialog> dialogs = projectToModalEntities.get(project);
            int perProjectIndex = dialogs.indexOf(dialog2);
            LOG.assertTrue(perProjectIndex >= 0);
            dialogs.remove(perProjectIndex);
            Stack<ModalityState> states = projectToModalEntitiesStack.get(project);
            states.remove(perProjectIndex + 1);
            for (int i2 = 1; i2 < states.size(); ++i2) {
                ((ModalityStateEx)((Object)states.get(i2))).removeModality(dialog2);
            }
        }
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeModality(@NotNull Object modalEntity, int index) {
        ourModalEntities.remove(index);
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            ourModalityStack.remove(index + 1);
            for (int i2 = 1; i2 < ourModalityStack.size(); ++i2) {
                ((ModalityStateEx)((Object)ourModalityStack.get(i2))).removeModality(modalEntity);
            }
        }
        ModalityStateEx.unmarkTransparent(modalEntity);
    }

    public static void leaveModal(@NotNull Object modalEntity) {
        LOG.assertTrue(LaterInvocator.isWriteThread(), (Object)"leaveModal() should be invoked in write thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false, modalEntity);
        int index = ourModalEntities.indexOf(modalEntity);
        LOG.assertTrue(index >= 0);
        LaterInvocator.removeModality(modalEntity, index);
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    public static void leaveAllModals() {
        while (!ourModalEntities.isEmpty()) {
            LaterInvocator.leaveModal(ourModalEntities.get(ourModalEntities.size() - 1));
        }
        LOG.assertTrue(LaterInvocator.getCurrentModalityState() == ModalityState.NON_MODAL, (Object)LaterInvocator.getCurrentModalityState());
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    public static Object @NotNull [] getCurrentModalEntities() {
        ApplicationManager.getApplication().assertIsWriteThread();
        return ArrayUtil.toObjectArray(ourModalEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ModalityStateEx getCurrentModalityState() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            return (ModalityStateEx)((Object)ourModalityStack.peek());
        }
    }

    public static boolean isInModalContextForProject(Project project) {
        LOG.assertTrue(LaterInvocator.isWriteThread());
        if (ourModalEntities.isEmpty()) {
            return false;
        }
        List<Dialog> modalEntitiesForProject = projectToModalEntities.get(project);
        return modalEntitiesForProject == null || modalEntitiesForProject.isEmpty();
    }

    public static boolean isInModalContext() {
        return LaterInvocator.isInModalContextForProject(null);
    }

    private static boolean isDispatchThread() {
        return ApplicationManager.getApplication().isDispatchThread();
    }

    private static boolean isWriteThread() {
        return ApplicationManager.getApplication().isWriteThread();
    }

    private static FlushQueue getRunnableQueue(boolean onEdt) {
        return onEdt ? ourEdtQueue : ourWtQueue;
    }

    static void requestFlush() {
        SUBMITTED_COUNT.incrementAndGet();
        while (FLUSHER_SCHEDULED.compareAndSet(false, true)) {
            int whichThread = THREAD_TO_FLUSH.getAndUpdate(operand -> operand ^ 1);
            long submittedCount = SUBMITTED_COUNT.get();
            FlushQueue firstQueue = LaterInvocator.getRunnableQueue(whichThread == 0);
            if (firstQueue.mayHaveItems()) {
                firstQueue.scheduleFlush();
                return;
            }
            FlushQueue secondQueue = LaterInvocator.getRunnableQueue(whichThread != 0);
            if (secondQueue.mayHaveItems()) {
                secondQueue.scheduleFlush();
                return;
            }
            FLUSHER_SCHEDULED.set(false);
            if (submittedCount != SUBMITTED_COUNT.get()) continue;
            break;
        }
    }

    public static void pollWriteThreadEventsOnce() {
        LOG.assertTrue(!SwingUtilities.isEventDispatchThread());
        LOG.assertTrue(ApplicationManager.getApplication().isWriteThread());
        ourWtQueue.flushNow();
    }

    public static boolean ensureFlushRequested() {
        if (ourEdtQueue.getNextEvent(false) != null) {
            ourEdtQueue.scheduleFlush();
            return true;
        }
        if (ourWtQueue.getNextEvent(false) != null) {
            ourWtQueue.scheduleFlush();
            return true;
        }
        return false;
    }

    public static Collection<FlushQueue.RunnableInfo> getLaterInvocatorEdtQueue() {
        return ourEdtQueue.getQueue();
    }

    @NotNull
    public static Collection<FlushQueue.RunnableInfo> getLaterInvocatorWtQueue() {
        return ourWtQueue.getQueue();
    }

    private static void pushRunnableToQueue(boolean onEdt, FlushQueue.RunnableInfo runnableInfo) {
        LaterInvocator.getRunnableQueue(onEdt).push(runnableInfo);
        LaterInvocator.requestFlush();
    }

    private static void reincludeSkippedItemsAndRequestFlush() {
        ourEdtQueue.reincludeSkippedItems();
        ourWtQueue.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    public static void purgeExpiredItems() {
        ourEdtQueue.purgeExpiredItems();
        ourWtQueue.purgeExpiredItems();
        LaterInvocator.requestFlush();
    }

    public static void dispatchPendingFlushes() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must call from EDT");
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        LaterInvocator.invokeLater(() -> ((Semaphore)semaphore).up(), ModalityState.any(), true);
        while (!semaphore.isUp()) {
            UIUtil.dispatchAllInvocationEvents();
        }
    }
}

