/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FlushQueue {
    private static final Logger LOG = Logger.getInstance(LaterInvocator.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private final Object LOCK = new Object();
    private final List<RunnableInfo> mySkippedItems = new ArrayList<RunnableInfo>();
    private final ArrayDeque<RunnableInfo> myQueue = new ArrayDeque();
    @NotNull
    private final Consumer<Runnable> myRunnableExecutor;
    private volatile boolean myMayHaveItems = false;
    private RunnableInfo myLastInfo;

    FlushQueue(@NotNull Consumer<Runnable> executor) {
        this.myRunnableExecutor = executor;
    }

    public void scheduleFlush() {
        this.myRunnableExecutor.accept(new FlushNow());
    }

    public void flushNow() {
        LaterInvocator.FLUSHER_SCHEDULED.set(false);
        this.myMayHaveItems = false;
        long startTime = System.currentTimeMillis();
        while (this.runNextEvent()) {
            if (System.currentTimeMillis() - startTime <= 5L) continue;
            this.myMayHaveItems = true;
            break;
        }
        LaterInvocator.requestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(@NotNull RunnableInfo runnableInfo) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myQueue.add(runnableInfo);
            this.myMayHaveItems = true;
        }
    }

    boolean mayHaveItems() {
        return this.myMayHaveItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Collection<RunnableInfo> getQueue() {
        Object object = this.LOCK;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.myQueue);
        }
    }

    private static void doRun(@Async.Execute RunnableInfo info) {
        if (ClientId.Companion.getPropagateAcrossThreads()) {
            ClientId.withClientId((ClientId)info.clientId, (Runnable)info.runnable);
        } else {
            info.runnable.run();
        }
    }

    public String toString() {
        return "LaterInvocator.FlushQueue" + (this.myLastInfo == null ? "" : " lastInfo=" + this.myLastInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    RunnableInfo getNextEvent(boolean remove) {
        Object object = this.LOCK;
        synchronized (object) {
            ModalityStateEx currentModality = LaterInvocator.getCurrentModalityState();
            while (!this.myQueue.isEmpty()) {
                RunnableInfo info = this.myQueue.getFirst();
                if (info.expired.value(null)) {
                    this.myQueue.removeFirst();
                    info.markDone();
                    continue;
                }
                if (!currentModality.dominates(info.modalityState)) {
                    if (remove) {
                        this.myQueue.removeFirst();
                    }
                    return info;
                }
                this.mySkippedItems.add(this.myQueue.removeFirst());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runNextEvent() {
        RunnableInfo lastInfo;
        long startedAt = System.currentTimeMillis();
        this.myLastInfo = lastInfo = this.getNextEvent(true);
        if (lastInfo != null) {
            EventWatcher watcher = EventWatcher.getInstance();
            Runnable runnable2 = lastInfo.runnable;
            if (watcher != null) {
                watcher.runnableStarted(runnable2, startedAt);
            }
            try {
                FlushQueue.doRun(lastInfo);
                lastInfo.markDone();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable t) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ExceptionUtil.rethrow((Throwable)t);
                }
                LOG.error(t);
            }
            finally {
                if (!DEBUG) {
                    this.myLastInfo = null;
                }
                if (watcher != null) {
                    watcher.runnableFinished(runnable2, startedAt);
                }
            }
        }
        return lastInfo != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reincludeSkippedItems() {
        Object object = this.LOCK;
        synchronized (object) {
            for (int i2 = this.mySkippedItems.size() - 1; i2 >= 0; --i2) {
                RunnableInfo item = this.mySkippedItems.get(i2);
                this.myQueue.addFirst(item);
                this.myMayHaveItems = true;
            }
            this.mySkippedItems.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeExpiredItems() {
        Object object = this.LOCK;
        synchronized (object) {
            this.reincludeSkippedItems();
            ArrayList<RunnableInfo> alive = new ArrayList<RunnableInfo>(this.myQueue.size());
            for (RunnableInfo info : this.myQueue) {
                if (info.expired.value(null)) {
                    info.markDone();
                    continue;
                }
                alive.add(info);
            }
            if (alive.size() < this.myQueue.size()) {
                this.myQueue.clear();
                this.myQueue.addAll(alive);
            }
        }
    }

    static final class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> expired;
        @Nullable
        private final ActionCallback callback;
        @Nullable
        private final ClientId clientId;

        @Async.Schedule
        RunnableInfo(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @Nullable ActionCallback callback2) {
            this.runnable = runnable2;
            this.modalityState = modalityState;
            this.expired = expired;
            this.callback = callback2;
            this.clientId = ClientId.getCurrent();
        }

        void markDone() {
            if (this.callback != null) {
                this.callback.setDone();
            }
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "] ";
        }
    }

    final class FlushNow
    implements Runnable {
        FlushNow() {
        }

        @Override
        public void run() {
            FlushQueue.this.flushNow();
        }
    }
}

