/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ApplicationEx
extends Application {
    public static final String LOCATOR_FILE_NAME = ".home";
    public static final int FORCE_EXIT = 1;
    public static final int EXIT_CONFIRMED = 2;
    public static final int SAVE = 4;
    public static final int ELEVATE = 8;

    public void load(@Nullable String var1);

    default public void load() {
        this.load(null);
    }

    public boolean holdsReadLock();

    public boolean isWriteActionInProgress();

    public boolean isWriteActionPending();

    @ApiStatus.Internal
    default public void acquireWriteIntentLock(@NotNull String invokedClassFqn) {
    }

    @ApiStatus.Internal
    default public void releaseWriteIntentLock() {
    }

    public boolean isSaveAllowed();

    public void setSaveAllowed(boolean var1);

    @Deprecated
    default public void doNotSave() {
        this.setSaveAllowed(false);
    }

    public boolean runProcessWithProgressSynchronouslyInReadAction(@Nullable Project var1, @NotNull String var2, boolean var3, String var4, JComponent var5, @NotNull Runnable var6);

    default public void exit(int flags) {
        this.exit();
    }

    default public void exit() {
        this.exit(4);
    }

    default public void exit(boolean force, boolean exitConfirmed) {
        int flags = 4;
        if (force) {
            flags |= 1;
        }
        if (exitConfirmed) {
            flags |= 2;
        }
        this.exit(flags);
    }

    public void restart(boolean var1);

    default public void restart() {
        this.restart(false);
    }

    public void restart(boolean var1, boolean var2);

    @ApiStatus.Internal
    default public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull @NlsContexts.ProgressTitle String progressTitle, boolean canBeCanceled, Project project) {
        return this.runProcessWithProgressSynchronously(process2, progressTitle, canBeCanceled, true, project, null, null);
    }

    @ApiStatus.Internal
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @NlsContexts.ProgressTitle String var2, boolean var3, boolean var4, @Nullable Project var5, JComponent var6, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String var7);

    public void assertIsDispatchThread(@Nullable JComponent var1);

    public void assertTimeConsuming();

    public boolean tryRunReadAction(@NotNull Runnable var1);

    @ApiStatus.Internal
    default public void executeByImpatientReader(@NotNull Runnable runnable2) throws ApplicationUtil.CannotRunReadActionException {
        runnable2.run();
    }

    @ApiStatus.Experimental
    default public boolean runWriteActionWithCancellableProgressInDispatchThread(@NotNull String title, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Experimental
    default public boolean runWriteActionWithNonCancellableProgressInDispatchThread(@NotNull String title, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    default public boolean isInImpatientReader() {
        return false;
    }

    @ApiStatus.Internal
    default public <T, E extends Throwable> T runUnlockingIntendedWrite(@NotNull ThrowableComputable<T, E> action2) throws E {
        return (T)action2.compute();
    }

    @ApiStatus.Internal
    default public void runIntendedWriteActionOnCurrentThread(@NotNull Runnable action2) {
        action2.run();
    }
}

